
/* NinjaSCSI32Bi pio func */
/* yokota@netlab.is.tsukuba.ac.jp */

static void nsp32_pio_read(Scsi_Cmnd *SCpnt)
{
	unsigned int base = SCpnt->host->io_port;
	int timeout;
	int cnt;
	unsigned long tmp;
	unsigned short i, fifo_stat;
	unsigned char busphase;

	//printk(__func__ "\n");

	timeout = 1000;

	fifo_stat = nsp32_read2(base, IRQ_STATUS);
	//nsp32_write2(base, IRQ_CONTROL, (fifo_stat & IRQ_CONTROL_ALL_IRQ_MASK) | FIFO_IRQ_MASK);

	while ((SCpnt->SCp.this_residual > 0 ||
		SCpnt->SCp.buffers_residual > 0 ) &&
	       (timeout-- != 0)) {

		if (SCpnt->resid == 0) {
			printk("resid=0\n");
			udelay(1);
			break;
		}

		i = nsp32_read2(base, FIFO_REST_CNT);
		busphase = nsp32_read1(base, SCSI_BUS_MONITOR) & BUSMON_PHASE_MASK;

		if (((i & FIFO_REST_MASK) == 0) &&
		    ((i & FIFO_FULL_SHLD_FLAG) == 0)) {
			if (busphase == BUSPHASE_DATA_IN) {
				//printk("c");
				continue;
			} else {
				//printk("phase change\n");
				//show_busphase(busphase);
				break;
			}
		}

		//printk("i 0x%x this 0x%x\n", i, SCpnt->SCp.this_residual);

		if(SCpnt->SCp.this_residual > 3) {
			cnt = MIN(i & FIFO_REST_MASK, SCpnt->SCp.this_residual) & ~3;

			//printk("read 0x%x\n", cnt);

			nsp32_fifo_read(base, SCpnt->SCp.ptr, cnt >> 2);

		} else {
			tmp = le32_to_cpu(nsp32_read4(base, FIFO_DATA_LOW));

			DEBUG(0, "r %d tmp=0x%08lx\n",SCpnt->SCp.this_residual, tmp);

			switch(SCpnt->SCp.this_residual) {
			case 3:
				//printk("3\n");
				cnt = 3;
				SCpnt->SCp.ptr[0] = (tmp & 0x000000ff) >> 0;
				SCpnt->SCp.ptr[1] = (tmp & 0x0000ff00) >> 8;
				SCpnt->SCp.ptr[2] = (tmp & 0x00ff0000) >> 16;

				break;
			case 2:
				//printk("2\n");
				cnt = 2;
				SCpnt->SCp.ptr[0] = (tmp & 0x000000ff) >> 0;
				SCpnt->SCp.ptr[1] = (tmp & 0x0000ff00) >> 8;
				break;
			case 1:
				//printk("1\n");
				cnt = 1;
				SCpnt->SCp.ptr[0] = (tmp & 0x000000ff) >> 0;
				break;
			default:
				cnt = 0;
				printk("this = 0???\n");
				break;
			}
		}

		SCpnt->SCp.ptr += cnt;
		SCpnt->SCp.this_residual -= cnt;
		SCpnt->resid -= cnt;

		if (SCpnt->SCp.this_residual	== 0 &&
		    SCpnt->SCp.buffers_residual != 0 ) {
			SCpnt->SCp.buffers_residual--;
			SCpnt->SCp.buffer++;
			SCpnt->SCp.ptr		 = BUFFER_ADDR;
			SCpnt->SCp.this_residual = SCpnt->SCp.buffer->length;

			//printk("next\n");
			timeout = 1000;
		}

	}

	//nsp32_write2(base, IRQ_CONTROL, (fifo_stat & IRQ_CONTROL_ALL_IRQ_MASK) & ~FIFO_IRQ_MASK);

	//printk(__func__ " out timeout %d\n", timeout);
}

static void nsp32_pio_write(Scsi_Cmnd *SCpnt)
{
	unsigned int base = SCpnt->host->io_port;
	int timeout;
	int cnt;
	unsigned long tmp;
	unsigned short i, fifo_stat;
	unsigned char busphase;

	timeout = 1000;

	fifo_stat = nsp32_read2(base, IRQ_STATUS);
	//nsp32_write2(base, IRQ_CONTROL, (fifo_stat & IRQ_CONTROL_ALL_IRQ_MASK) | FIFO_IRQ_MASK);

	while (((SCpnt->SCp.this_residual > 0) || (SCpnt->SCp.buffers_residual > 0) ) &&
	       (timeout-- != 0)) {

		if (SCpnt->resid == 0) {
			break;
		}

		i = nsp32_read2(base, FIFO_REST_CNT);
		busphase = nsp32_read1(base, SCSI_BUS_MONITOR) & BUSMON_PHASE_MASK;

		if (((i & FIFO_REST_CNT) != 0) &&
		    ((i & FIFO_EMPTY_SHLD_FLAG) == 0)) {
			if (busphase == BUSPHASE_DATA_OUT) {
				//printk("c");
				continue;
			} else {
				//printk("phase change\n");
				//show_busphase(busphase);
				break;
			}
		}

		if(SCpnt->SCp.this_residual > 3) {
			cnt = MIN(SCpnt->SCp.this_residual, (FIFO_MAX / 2)) & ~3;

			//printk("write 0x%x\n", cnt);

			nsp32_fifo_write(base, SCpnt->SCp.ptr, cnt >> 2);

		} else {
			switch(SCpnt->SCp.this_residual) {
			case 3:
				//printk("3\n");
				cnt = 3;
				tmp = SCpnt->SCp.ptr[0] << 0 |
					SCpnt->SCp.ptr[1] << 8 |
					SCpnt->SCp.ptr[2] << 16;
				break;
			case 2:
				//printk("2\n");
				cnt = 2;
				tmp = SCpnt->SCp.ptr[0] << 0 |
					SCpnt->SCp.ptr[1] << 8;
				break;
			case 1:
				//printk("1\n");
				cnt = 1;
				tmp = SCpnt->SCp.ptr[0] << 0;
				break;
			default:
				cnt = 0;
				printk("this = 0???\n");
				tmp = 0;
				break;
			}

			DEBUG(0, "w %d tmp=0x%lx\n",SCpnt->SCp.this_residual, tmp);

			nsp32_write4(base, FIFO_DATA_LOW, cpu_to_le32(tmp));

		}

		SCpnt->SCp.ptr += cnt;
		SCpnt->SCp.this_residual -= cnt;
		SCpnt->resid -= cnt;

		if (SCpnt->SCp.this_residual	== 0 &&
		    SCpnt->SCp.buffers_residual != 0 ) {
			SCpnt->SCp.buffers_residual--;
			SCpnt->SCp.buffer++;
			SCpnt->SCp.ptr		 = BUFFER_ADDR;
			SCpnt->SCp.this_residual = SCpnt->SCp.buffer->length;
			timeout = 1000;
		}
	}

	//nsp32_write2(base, IRQ_CONTROL, (fifo_stat & IRQ_CONTROL_ALL_IRQ_MASK) & ~FIFO_IRQ_MASK);
}

/* end */
