
#define PCI_VENDOR_ID_IODATA  0x10fc
#define PCI_VENDOR_ID_WORKBIT 0x1145

#define PCI_DEVICE_ID_NINJASCSI_32BI_CBSC_II  0x0005
#define PCI_DEVICE_ID_NINJASCSI_32BI_KME      0xf007
#define PCI_DEVICE_ID_NINJASCSI_32BI_WBT      0x8007
#define PCI_DEVICE_ID_LOGITEC_TEST            0xf010
#define PCI_DEVICE_ID_NINJASCSI_32BI_LOGITEC  0xf012
#define PCI_DEVICE_ID_NINJASCSI_32BIB_LOGITEC 0xf013


#define BIT(x) (1UL << (x))
#define MIN(a,b)    ((a) > (b) ? (b) : (a))

#define FIFO_MAX 128


#define IRQ_CONTROL 0x00
#define IRQ_STATUS  0x00
# define IRQSTATUS_LATCHED_MSG      BIT(0)
# define IRQSTATUS_LATCHED_IO       BIT(1)
# define IRQSTATUS_LATCHED_CD       BIT(2)
# define IRQSTATUS_LATCHED_BUS_FREE BIT(3)
# define IRQSTATUS_RESELECT_OCCUER  BIT(4)
# define IRQSTATUS_PHASE_CHANGE_IRQ BIT(5)
# define IRQSTATUS_SCSIRESET_IRQ    BIT(6)
# define IRQSTATUS_TIMER_IRQ        BIT(7)
# define IRQSTATUS_FIFO_SHLD_IRQ    BIT(8)
# define IRQSTATUS_CARDBUS_IRQ      BIT(9)
# define IRQSTATUS_BMCNTERR_IRQ     BIT(10)
# define IRQSTATUS_AUTOSCSI_IRQ     BIT(11)
# define CARDBUS_IRQ_MASK           BIT(12)
# define TIMER_IRQ_MASK             BIT(13)
# define FIFO_IRQ_MASK              BIT(14)
# define SCSI_IRQ_MASK              BIT(15)
# define IRQ_CONTROL_ALL_IRQ_MASK   0xf000
# define IRQSTATUS_ANY_IRQ          (IRQSTATUS_RESELECT_OCCUER  | \
				     IRQSTATUS_PHASE_CHANGE_IRQ | \
				     IRQSTATUS_SCSIRESET_IRQ    | \
				     IRQSTATUS_TIMER_IRQ        | \
				     IRQSTATUS_FIFO_SHLD_IRQ    | \
				     IRQSTATUS_CARDBUS_IRQ      | \
				     IRQSTATUS_BMCNTERR_IRQ     | \
				     IRQSTATUS_AUTOSCSI_IRQ      )

#define TRANSFER_CONTROL 0x02
#define TRANSFER_STATUS  0x02
# define CB_MMIO_MODE      BIT(0)
# define CB_IO_MODE        BIT(1)
# define BM_TEST           BIT(2)
# define BM_TEST_DIR       BIT(3)
//
# define TRANSFER_GO       BIT(7)
# define BLIEND_MODE       BIT(8)
# define BM_START          BIT(9)
# define ADVANCED_BM_WRITE BIT(10)
# define BM_SINGLE_MODE    BIT(11)
# define FIFO_TRUE_FULL    BIT(12)
# define FIFO_TRUE_EMPTY   BIT(13)
# define ALL_COUNTER_CLR   BIT(14)
# define FIFOTEST          BIT(15)


#define INDEX_REG 0x04




#define TIMER_SET 0x06
# define TIMER_CNT_MASK 0xff
# define TIMER_STOP     BIT(8)


#define DATA_REG_LOW 0x08
#define DATA_REG_HI 0x0a

#define FIFO_REST_CNT 0x0c
# define FIFO_REST_MASK       0x1ff
# define FIFO_EMPTY_SHLD_FLAG BIT(14)
# define FIFO_FULL_SHLD_FLAG  BIT(15)

#define SREQ_SMPL_RATE 0x0f
# define SAMPLING_ENABLE BIT(2)

#define SCSI_BUS_CONTROL 0x10
# define BUSCTL_SEL         BIT(0)
# define BUSCTL_RST         BIT(1)
# define BUSCTL_DATAOUT_ENB BIT(2)
# define BUSCTL_ATN         BIT(3)
# define BUSCTL_ACK         BIT(4)
# define BUSCTL_BSY         BIT(5)
# define AUTODIRECTION      BIT(6)
# define ACKENB             BIT(7)


#define CLR_COUNTER 0x12
# define ACK_COUNTER_CLR       BIT(0)
# define SREQ_COUNTER_CLR      BIT(1)
# define FIFO_HOST_POINTER_CLR BIT(2)
# define FIFO_REST_COUNT_CLR   BIT(3)
# define BM_COUNTER_CLR        BIT(4)
# define SAVED_ACK_CLR         BIT(5)


#define SCSI_BUS_MONITOR 0x12
# define BUSMON_MSG BIT(0)
# define BUSMON_IO  BIT(1)
# define BUSMON_CD  BIT(2)
# define BUSMON_BSY BIT(3)
# define BUSMON_ACK BIT(4)
# define BUSMON_REQ BIT(5)
# define BUSMON_SEL BIT(6)
# define BUSMON_ATN BIT(7)

#define COMMAND_DATA 0x14

#define PARITY_CONTROL 0x16
# define PARITY_CHECK_ENABLE BIT(0)
# define PARITY_ERROR_CLEAR  BIT(1)
#define PARITY_STATUS  0x16
//# define PARITY_CHECK_ENABLE BIT(0)
# define PARITY_ERROR        BIT(1)

#define COMMAND_CONTROL 0x18
# define CLEAR_CDB_FIFO_POINTER BIT(0)
# define AUTO_COMMAND_PHASE     BIT(1)
# define AUTOSCSI_START         BIT(2)
# define AUTOSCSI_RESTART       BIT(3)
# define AUTO_PARAMETER         BIT(4)
# define AUTO_ATN               BIT(5)
# define AUTO_MSGIN_00_OR_04    BIT(6)
# define AUTO_MSGIN_02          BIT(7)
# define AUTO_MSGIN_03          BIT(8)

#define RESELECT_ID 0x18

#define SET_ARBIT 0x1a
# define ARBIT_GO    BIT(0)
# define ARBIT_CLEAR BIT(1)

#define ARBIT_STATUS 0x1a
//# define ARBIT_GO BIT(0)
# define ARBIT_WIN            BIT(1)
# define ARBIT_FAIL           BIT(2)
# define AUTO_PARAMETER_VALID BIT(3)
# define SGT_VALID            BIT(4)

#define SYNC_REG 0x1c

#define ACK_WIDTH 0x1d

#define SCSI_DATA_WITH_ACK 0x20
#define SCSI_OUT_LATCH_TARGET_ID 0x22
#define SCSI_DATA_IN 0x22

#define SCAM_CONTROL 0x24
#define SCAM_STATUS  0x24
# define SCAM_MSG    BIT(0)
# define SCAM_IO     BIT(1)
# define SCAM_CD     BIT(2)
# define SCAM_BSY    BIT(3)
# define SCAM_SEL    BIT(4)
# define SCAM_XFEROK BIT(5)

#define SCAM_DATA 0x26


#define SACK_CNT 0x28
#define SREQ_CNT 0x2c

#define FIFO_DATA_LOW 0x30
#define FIFO_DATA_HIGH 0x32
#define BM_START_ADR 0x34

#define BM_CNT 0x38
# define BM_COUNT_MASK 0x0001ffff
# define SGTEND        BIT(31)

#define SGT_ADR 0x3c
#define WAIT_REG 0x40

#define SCSI_EXECUTE_PHASE 0x40
# define COMMAND_PHASE     BIT(0)
# define DATA_IN_PHASE     BIT(1)
# define DATA_OUT_PHASE    BIT(2)
# define MSGOUT_PHASE      BIT(3)
# define STATUS_PHASE      BIT(4)
# define ILLEGAL_PHASE     BIT(5)
# define BUS_FREE_OCCUER   BIT(6)
# define MSG_IN_OCCUER     BIT(7)
# define MSG_OUT_OCCUER    BIT(8)
# define SELECTION_TIMEOUT BIT(9)
# define MSGIN_00_VALID    BIT(10)
# define MSGIN_02_VALID    BIT(11)
# define MSGIN_03_VALID    BIT(12)
# define MSGIN_04_VALID    BIT(13)
# define AUTOSCSI_BUSY     BIT(15)


#define SCSI_CSB_IN 0x42

#define SCSI_MSG_OUT 0x44
# define MSGOUT_COUNT_MASK (BIT(0)|BIT(1))
# define MSGOUT_VALID      BIT(7)

#define SEL_TIME_OUT 0x48
#define SAVED_SACK_CNT 0x4c




/* indexed reg */

#define CLOCK_DIV 0x00
# define SCSI_XFER_CLK_SELECT BIT(7)


#define TERM_PWR_CONTROL 0x01
# define BPWR  BIT(0)
# define SENSE BIT(1)

#define EXT_PORT_DDR 0x02
#define EXT_PORT 0x03

#define IRQ_SELECT 0x04
# define IRQSELECT_RESELECT_IRQ      BIT(0)
# define IRQSELECT_PHASE_CHANGE_IRQ  BIT(1)
# define IRQSELECT_SCSIRESET_IRQ     BIT(2)
# define IRQSELECT_TIMER_IRQ         BIT(3)
# define IRQSELECT_FIFO_SHLD_IRQ     BIT(4)
# define IRQSELECT_TARGET_ABORT_IRQ  BIT(5)
# define IRQSELECT_MASTER_ABORT_IRQ  BIT(6)
# define IRQSELECT_SERR_IRQ          BIT(7)
# define IRQSELECT_PERR_IRQ          BIT(8)
# define IRQSELECT_BMCNTERR_IRQ      BIT(9)
# define IRQSELECT_AUTO_SCSI_SEQ_IRQ BIT(10)

#define OLD_SCSI_PHASE 0x05
# define OLD_MSG  BIT(0)
# define OLD_IO   BIT(1)
# define OLD_CD   BIT(2)
# define OLD_BUSY BIT(3)

#define FIFO_FULL_SHLD_COUNT 0x06
#define FIFO_EMPTY_SHLD_COUNT 0x07

#define EXP_ROM_CONTROL 0x08
//
#define CHIP_MODE 0x0b
# define OEM0 BIT(1)
# define OEM1 BIT(2)
# define OPTB BIT(3)
# define OPTC BIT(4)
# define OPTD BIT(5)
# define OPTE BIT(6)
# define OPTF BIT(7)

#define MISC_WR 0x0c
# define SCSI_DIRECTION_DETECTOR_SELECT BIT(0)
# define DELAYED_BMSTART                BIT(3)
# define MASTER_TERMINATION_SELECT      BIT(4)
# define BMREQ_NEGATE_TIMING_SEL        BIT(5)
# define AUTOSEL_TIMING_SEL             BIT(6)


#define MISC_RD 0x0c

#define BM_CYCLE 0x0d
# define MEMRD_CMD0              BIT(5)
# define SGT_AUTO_PARA_MEMED_CMD BIT(6)
# define MEMRD_CMD1              BIT(7)


#define SREQ_EDGH 0x0e
# define SREQ_EDGH_SELECT BIT(0)

#define CFG_CMD_STR 0x10
#define CFG_LATE_CACHE 0x11
#define CFG_BASE_ADR_1 0x12
#define CFG_BASE_ADR_2 0x13
#define CFG_INLINE 0x14
#define FIFO_HST_POINTER 0x16


/*
 * Useful Bus Monitor status combinations.
 */
#define BUSMON_BUS_FREE    0
#define BUSMON_COMMAND     ( BUSMON_BSY |                          BUSMON_CD | BUSMON_REQ )
#define BUSMON_MESSAGE_IN  ( BUSMON_BSY | BUSMON_MSG | BUSMON_IO | BUSMON_CD | BUSMON_REQ )
#define BUSMON_MESSAGE_OUT ( BUSMON_BSY | BUSMON_MSG |             BUSMON_CD | BUSMON_REQ )
#define BUSMON_DATA_IN     ( BUSMON_BSY |              BUSMON_IO |             BUSMON_REQ )
#define BUSMON_DATA_OUT    ( BUSMON_BSY |                                      BUSMON_REQ )
#define BUSMON_STATUS      ( BUSMON_BSY |              BUSMON_IO | BUSMON_CD | BUSMON_REQ )
#define BUSMON_RESELECT    (                           BUSMON_IO                          | BUSMON_SEL)
#define BUSMON_PHASE_MASK  (              BUSMON_MSG | BUSMON_IO | BUSMON_CD              | BUSMON_SEL)

#define BUSPHASE_COMMAND     ( BUSMON_COMMAND     & BUSMON_PHASE_MASK )
#define BUSPHASE_MESSAGE_IN  ( BUSMON_MESSAGE_IN  & BUSMON_PHASE_MASK )
#define BUSPHASE_MESSAGE_OUT ( BUSMON_MESSAGE_OUT & BUSMON_PHASE_MASK )
#define BUSPHASE_DATA_IN     ( BUSMON_DATA_IN     & BUSMON_PHASE_MASK )
#define BUSPHASE_DATA_OUT    ( BUSMON_DATA_OUT    & BUSMON_PHASE_MASK )
#define BUSPHASE_STATUS      ( BUSMON_STATUS      & BUSMON_PHASE_MASK )
#define BUSPHASE_SELECT      ( BUSMON_SEL | BUSMON_IO )






#define MSG_NO_OPERATION     0x08


#if (LINUX_VERSION_CODE > KERNEL_VERSION(2,5,2))
# define BUFFER_ADDR ((char *)((unsigned int)(SCpnt->SCp.buffer->page) + SCpnt->SCp.buffer->offset))
#else
# define BUFFER_ADDR SCpnt->SCp.buffer->address
#endif

enum {
	MODEL_IODATA  = 0,
	MODEL_KME     = 1,
	MODEL_WORKBIT = 2,
	MODEL_EXP_ROM = 3
};

static char * nsp32_model[] = {
	"I-O DATA CBSC-II",
	"KME SCSI card",
	"Workbit duo SCSI card",
	"External ROM",
};

/* end */
