/* NinjaSCSI32Bi CardBus mode driver for Linux 2.4 */
/* YOKOTA Hiroshi <yokota@netlab.is.tsukuba.ac.jp> */

/* $Id: nsp32_cb.c,v 1.14 2002/03/27 12:46:09 elca Exp $ */

#include <linux/module.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/slab.h>
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/ioport.h>
#include <scsi/scsi.h>
#include <linux/major.h>
#include <linux/blk.h>
#include <linux/pci.h>
#include <linux/delay.h>

#include <linux/ctype.h>

#include <../drivers/scsi/scsi.h>
#include <../drivers/scsi/hosts.h>
#include <scsi/scsi_ioctl.h>


#include <pcmcia/driver_ops.h>

#include "nsp32_cb.h"


//#define PCMCIA_DEBUG 9

#ifdef PCMCIA_DEBUG
static int pc_debug = PCMCIA_DEBUG;
MODULE_PARM(pc_debug, "i");
#define DEBUG(n, args...) if (pc_debug>(n)) printk(/*KERN_DEBUG*/ args)
static char *version = "nsp32_cb $Revision: 1.14 $";
#else
#define DEBUG(n, args...)
#endif

MODULE_LICENSE("GPL");

static int nsp32_detect(Scsi_Host_Template *sht);
static int nsp32_queuecommand(Scsi_Cmnd *SCpnt, void (*done)(Scsi_Cmnd *));
static const char *nsp32_info(struct Scsi_Host *shpnt);
static int nsp32_eh_bus_reset(Scsi_Cmnd *SCpnt);
static int nsp32_eh_host_reset(Scsi_Cmnd *SCpnt);
static int nsp32_reset(Scsi_Cmnd *SCpnt, unsigned int reset_flags);
static int nsp32_release(struct Scsi_Host *shpnt);
static int nsp32_proc_info(char  *buffer, char **start, off_t offset, int length, int hostno, int inout);


typedef struct _nsp32_hw_data {
	int IrqNumber;
	int BaseAddress;
	int NumAddress;
#define NSP32_MMIO_OFFSET 0x0800
	unsigned long MmioAddress;


	Scsi_Cmnd *CurrentSC;

	struct pci_dev *Pci;

	char info_str[100];

	unsigned char MsgBuffer[20];
//	char *autoparam;

	struct Scsi_Host *Host;
	spinlock_t Lock;

} nsp32_hw_data;
static nsp32_hw_data nsp32_data;

#include "nsp32_io.h"


static Scsi_Host_Template driver_template = {
	proc_name:	        "nsp32_cb",
	name:			"WorkBit NinjaSCSI-32Bi",
	proc_info:              nsp32_proc_info,
	detect:                 nsp32_detect,
	info:                   nsp32_info,
	queuecommand:		nsp32_queuecommand,
	can_queue:		1,
	sg_tablesize:           32,
        cmd_per_lun:            1,
	this_id:                7,
	use_clustering:         DISABLE_CLUSTERING,
	eh_bus_reset_handler:	nsp32_eh_bus_reset,
	eh_host_reset_handler:  nsp32_eh_host_reset,
	reset:                  nsp32_reset,
	release:                nsp32_release,
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,5,2))
	use_new_eh_code:        1,
#endif
};

#ifdef PCMCIA_DEBUG
# include "nsp32_debug.c"
#else
# define show_command(arg)   /* */
# define show_busphase(arg)  /* */
# define show_autophase(arg) /* */
#endif

#include "nsp32_pio.c"

/*
static void nsp32_start_timer(Scsi_Cmnd *SCpnt, int time)
{
	unsigned int base = SCpnt->host->io_port;

	DEBUG(0, __func__ " time=%d\n", time);

	if (time & (~TIMER_CNT_MASK)) {
		printk("timer set overflow\n");
	}

	nsp32_write2(base, TIMER_SET, time & TIMER_CNT_MASK);
}
*/

static unsigned int nsp32hw_start_selection(Scsi_Cmnd *SCpnt)
{
	unsigned int  host_id    = SCpnt->host->this_id;
	unsigned int  base       = SCpnt->host->io_port;
	unsigned char target     = SCpnt->target;
	unsigned char lun = SCpnt->lun;
	unsigned char phase, arbit;
//	nsp32_hw_data *data = &nsp32_data;
	int i, timeout;

	phase = nsp32_read1(base, SCSI_BUS_MONITOR);
	if (phase != BUSMON_BUS_FREE) {
		printk( " bus busy\n");
		show_busphase(phase & BUSMON_PHASE_MASK);
		return FALSE;
	}

	nsp32_write2(base, TRANSFER_CONTROL, ALL_COUNTER_CLR);
	nsp32_write2(base, SEL_TIME_OUT, 10000);
	nsp32_write1(base, SYNC_REG, 0);
	nsp32_write1(base, ACK_WIDTH, 0);

	nsp32_write2(base, COMMAND_CONTROL, CLEAR_CDB_FIFO_POINTER);
	for (i=0; i < SCpnt->cmd_len; i++) {
		nsp32_write1(base, COMMAND_DATA, SCpnt->cmnd[i]);
	}

	nsp32_write1(base, SCSI_OUT_LATCH_TARGET_ID, (1 << host_id) | (1 << target));

	nsp32_write4(base, SGT_ADR, 0);
	nsp32_write4(base, BM_START_ADR, 0);
	nsp32_write4(base, BM_CNT,       0);

	nsp32_write4(base, SCSI_MSG_OUT, (IDENTIFY(TRUE, lun) << 24) | MSGOUT_VALID | 1);

	nsp32_write2(base, TRANSFER_CONTROL, /*BM_START |*/ TRANSFER_GO | ALL_COUNTER_CLR | /*BM_SINGLE_MODE |*/ BLIEND_MODE | CB_IO_MODE);

	nsp32_write2(base, COMMAND_CONTROL, CLEAR_CDB_FIFO_POINTER |
		                            AUTOSCSI_START |
		                            AUTO_MSGIN_00_OR_04 |
		                            AUTO_MSGIN_02 |
		                            AUTO_ATN);

	timeout = 1000;
	do {
		arbit = nsp32_read1(base, ARBIT_STATUS);
		//printk(" arbit=0x%x\n", arbit);
	} while ((arbit & (ARBIT_WIN | ARBIT_FAIL)) == 0 &&
		 (timeout-- != 0));

	if((arbit & ARBIT_WIN) == 0) {
		DEBUG(0, " arbit fail\n");
		nsp32_write1(base, SET_ARBIT, ARBIT_CLEAR);
		return FALSE;
        }

	nsp32_write1(base, SET_ARBIT, ARBIT_CLEAR);


	return TRUE;
}

static void nsp32_reselected(Scsi_Cmnd *SCpnt)
{
	unsigned int base = SCpnt->host->io_port;
	unsigned char reg;

	//nsp32_negate_signal(SCpnt, BUSMON_SEL);

	reg = nsp32_read1(base, SCSI_BUS_CONTROL);
	nsp32_write1(base, SCSI_BUS_CONTROL, reg & ~BUSCTL_ACK);
}

static int nsp32_queuecommand(Scsi_Cmnd *SCpnt, void (*done)(Scsi_Cmnd *))
{
//	unsigned int base = SCpnt->host->io_port;
//	unsigned char target = SCpnt->target;
	nsp32_hw_data *data = &nsp32_data;
//	int i;

//	DEBUG(0, __func__ "() SCpnt=0x%p target=%d lun=%d buff=0x%p bufflen=%d use_sg=%d\n",
//	      SCpnt, target, SCpnt->lun, SCpnt->request_buffer, SCpnt->request_bufflen, SCpnt->use_sg);

	if (data->CurrentSC != NULL ) {
		printk("Currentsc != NULL\n");
		SCpnt->result   = DID_NO_CONNECT << 16;
		done(SCpnt);

		return -1;
	}


//	show_command(SCpnt);

	SCpnt->scsi_done     = done;
	data->CurrentSC      = SCpnt;
	SCpnt->SCp.Status    = CHECK_CONDITION;
	SCpnt->SCp.Message   = 0;
	SCpnt->resid         = SCpnt->request_bufflen;

	/* setup scratch area
	   SCp.ptr		: buffer pointer
	   SCp.this_residual	: buffer length
	   SCp.buffer		: next buffer
	   SCp.buffers_residual : left buffers in list
	   SCp.phase		: current state of the command */
	if (SCpnt->use_sg) {
		SCpnt->SCp.buffer	    = (struct scatterlist *) SCpnt->request_buffer;
		SCpnt->SCp.ptr		    = BUFFER_ADDR;
		SCpnt->SCp.this_residual    = SCpnt->SCp.buffer->length;
		SCpnt->SCp.buffers_residual = SCpnt->use_sg - 1;
	} else {
		SCpnt->SCp.ptr		    = (char *) SCpnt->request_buffer;
		SCpnt->SCp.this_residual    = SCpnt->request_bufflen;
		SCpnt->SCp.buffer	    = NULL;
		SCpnt->SCp.buffers_residual = 0;
	}


//	nsp32_eh_bus_reset(SCpnt); // xxx

	if (nsp32hw_start_selection(SCpnt) != TRUE) {
		SCpnt->result   = DID_NO_CONNECT << 16;
		data->CurrentSC = NULL;
		SCpnt->scsi_done(SCpnt);

		return -1;
	}



	return 0;
}

static int nsp32hw_init(struct Scsi_Host *host)
{
	unsigned int  base = host->io_port;
	unsigned short irq_stat;
	unsigned long lc_reg;
	unsigned char power;

	lc_reg = nsp32_index_read4(base, CFG_LATE_CACHE);
	if ((lc_reg & 0xff00) == 0) {
		lc_reg |= (0x20 << 8);
		nsp32_index_write2(base, CFG_LATE_CACHE, lc_reg & 0xffff);
	}

	nsp32_write2(base, IRQ_CONTROL,      IRQ_CONTROL_ALL_IRQ_MASK);
	nsp32_write2(base, TRANSFER_CONTROL, 0);
	nsp32_write4(base, BM_CNT,           0);

	do {
		irq_stat = nsp32_read2(base, IRQ_STATUS);
	} while (irq_stat & IRQSTATUS_ANY_IRQ);
//	DEBUG(0, "irq_stat 0x%x\n", irq_stat);

	nsp32_index_write1(base, FIFO_FULL_SHLD_COUNT,  0x40);
	nsp32_index_write1(base, FIFO_EMPTY_SHLD_COUNT, 0x40);

	//DEBUG(0, "full 0x%x emp 0x%x\n", nsp32_index_read1(base, FIFO_FULL_SHLD_COUNT), nsp32_index_read1(base, FIFO_EMPTY_SHLD_COUNT));

	nsp32_index_write1(base, CLOCK_DIV, 2);

	nsp32_write1(base, PARITY_CONTROL, 0);
	nsp32_index_write1(base, MISC_WR,  SCSI_DIRECTION_DETECTOR_SELECT |
			                   MASTER_TERMINATION_SELECT      |
			                   AUTOSEL_TIMING_SEL             );
	nsp32_index_write1(base, BM_CYCLE, MEMRD_CMD1 | SGT_AUTO_PARA_MEMED_CMD);

	nsp32_index_write1(base, TERM_PWR_CONTROL, 0);
	power = nsp32_index_read1(base, TERM_PWR_CONTROL);
	if (!(power & SENSE)) {
		printk("term power on\n");
		nsp32_index_write1(base, TERM_PWR_CONTROL, BPWR);
	}

	nsp32_write2(base, TIMER_SET, TIMER_STOP);
	nsp32_write2(base, TIMER_SET, TIMER_STOP);

	nsp32_write1(base, SYNC_REG,  0);
	nsp32_write1(base, ACK_WIDTH, 0);


	nsp32_index_write2(base, IRQ_SELECT, IRQSELECT_TIMER_IRQ         |
			                     IRQSELECT_SCSIRESET_IRQ     |
			                     IRQSELECT_FIFO_SHLD_IRQ     |
			                     IRQSELECT_RESELECT_IRQ      |
			                     IRQSELECT_PHASE_CHANGE_IRQ  |
			                     IRQSELECT_AUTO_SCSI_SEQ_IRQ |
			                     //IRQSELECT_BMCNTERR_IRQ      |
			                     IRQSELECT_TARGET_ABORT_IRQ  |
			                     IRQSELECT_MASTER_ABORT_IRQ );
	nsp32_write2(base, IRQ_CONTROL, 0);

	return TRUE;
}



static void nsp32intr(int irq, void *dev_id, struct pt_regs *regs)
{
	nsp32_hw_data *data = dev_id;
	unsigned int base;
	Scsi_Cmnd *SCpnt;
	unsigned short auto_stat, irq_stat, trans_stat;
	unsigned char busmon, busphase;

	base = data->BaseAddress;

	irq_stat = nsp32_read2(base, IRQ_STATUS);

	if ((irq_stat & IRQSTATUS_ANY_IRQ) == 0) {
		//DEBUG(0, __func__ " irq other 0x%x\n", irq_stat);

		return;
	}

	busmon = nsp32_read1(base, SCSI_BUS_MONITOR);
	busphase = busmon & BUSMON_PHASE_MASK;
	trans_stat = nsp32_read2(base, TRANSFER_STATUS);

	if ((irq_stat == 0xffff) && (trans_stat == 0xffff)) {
		printk(__func__ " card disconnect\n");
		if (data->CurrentSC != NULL) {
			printk(" clean up current SCSI command\n");
			SCpnt           = data->CurrentSC;
			data->CurrentSC = NULL;
			SCpnt->result   = DID_BAD_TARGET << 16;
			SCpnt->scsi_done(SCpnt);
		}
		return;
	}

	if (irq_stat & IRQSTATUS_TIMER_IRQ) {
		DEBUG(0, "timer stop\n");
		nsp32_write2(base, TIMER_SET, TIMER_STOP);
		return;
	}

	SCpnt = data->CurrentSC;

	if(SCpnt == NULL) {
		printk("SCpnt==NULL\n");
		printk("irq_stat=0x%x trans_stat=0x%x\n", irq_stat, trans_stat);
		return;
	}

	if(irq_stat & IRQSTATUS_AUTOSCSI_IRQ) {
		auto_stat = nsp32_read2(base, SCSI_EXECUTE_PHASE);


		if(auto_stat & SELECTION_TIMEOUT) {
//			DEBUG(0, "sel timeout\n");
			data->CurrentSC = NULL;
			SCpnt->result   = DID_NO_CONNECT << 16;
			SCpnt->scsi_done(SCpnt);
			return;
		}


		if ((auto_stat & DATA_IN_PHASE) &&
		    (SCpnt->resid > 0) &&
		    ((nsp32_read2(base, FIFO_REST_CNT) & FIFO_REST_MASK) != 0)) {
			//DEBUG(0, "auto+fifo\n");
			nsp32_pio_read(SCpnt);
		}

		if(auto_stat & MSGIN_04_VALID){
			SCpnt->SCp.Status  = nsp32_read1(base, SCSI_CSB_IN);
			SCpnt->SCp.Message = 4;
			//DEBUG(0, "disconnect\n");
			return;
		}
		if(auto_stat & MSGIN_00_VALID){
			SCpnt->SCp.Status  = nsp32_read1(base, SCSI_CSB_IN);
			SCpnt->SCp.Message = 0;

			//DEBUG(0, "normal end stat=0x%x resid=0x%x\n", SCpnt->SCp.Status, SCpnt->resid);

			data->CurrentSC = NULL;
			SCpnt->result   = (DID_OK << 16) | (SCpnt->SCp.Message << 8) | (SCpnt->SCp.Status << 0);
			SCpnt->scsi_done(SCpnt);
			return;
		}

		if(auto_stat & MSG_IN_OCCUER) {
			DEBUG(0, "msgin occuer\n");

			SCpnt->SCp.Message = nsp32_read1(base, SCSI_DATA_WITH_ACK);

			nsp32_write2(base, COMMAND_CONTROL, CLEAR_CDB_FIFO_POINTER |
				                            AUTOSCSI_RESTART       |
				                            AUTO_MSGIN_00_OR_04    |
				                            AUTO_MSGIN_02          );
			return;
		}
		if(auto_stat & MSG_OUT_OCCUER) {
			DEBUG(0, "msgout occuer\n");

			nsp32_write4(base, SCSI_MSG_OUT, (IDENTIFY(TRUE, SCpnt->lun) << 24) | MSGOUT_VALID | 1);

			nsp32_write2(base, COMMAND_CONTROL, CLEAR_CDB_FIFO_POINTER |
				                            AUTOSCSI_RESTART       |
				                            AUTO_MSGIN_00_OR_04    |
				                            AUTO_MSGIN_02          );
			return;
		}

		if(auto_stat & BUS_FREE_OCCUER) {
			DEBUG(0, "bus free occuer\n");
			data->CurrentSC = NULL;
			SCpnt->result   = (DID_OK << 16) | (SCpnt->SCp.Message << 8) | (SCpnt->SCp.Status << 0);
			SCpnt->scsi_done(SCpnt);
			return;
		}



		printk("autoscsi other\n");
		show_autophase(auto_stat);

		data->CurrentSC = NULL;
		SCpnt->result = DID_BAD_TARGET << 16;
		SCpnt->scsi_done(SCpnt);

		return;
	}


//	show_busphase(busphase);


	if (irq_stat & IRQSTATUS_FIFO_SHLD_IRQ) {
		//DEBUG(0, "fifo\n");
		switch(busphase) {
		case BUSPHASE_DATA_OUT:

			nsp32_pio_write(SCpnt);

			break;

		case BUSPHASE_DATA_IN:
			//DEBUG(0, "read\n");

			nsp32_pio_read(SCpnt);

			break;

		case BUSPHASE_STATUS:
			//DEBUG(0, "fifo/status\n");

			SCpnt->SCp.Status = nsp32_read1(base, SCSI_CSB_IN);

			break;
		default:
			printk("fifo/other phase?\n");
			printk("irq_stat=0x%x trans_stat=0x%x\n", irq_stat, trans_stat);
			show_busphase(busphase);
			break;
		}

		return;
	}

	if (irq_stat & IRQSTATUS_PHASE_CHANGE_IRQ) {
		switch(busphase) {
		case BUSPHASE_MESSAGE_IN:
			//DEBUG(0, "phase chg/msg in\n");

			SCpnt->SCp.Message = nsp32_read1(base, SCSI_DATA_WITH_ACK);

			if (irq_stat & IRQSTATUS_RESELECT_OCCUER) {
				//DEBUG(0, "reselected\n");

				nsp32_read1(base, RESELECT_ID);
				nsp32_write2(base, COMMAND_CONTROL, CLEAR_CDB_FIFO_POINTER |
					                            AUTOSCSI_RESTART       |
					                            AUTO_MSGIN_00_OR_04    |
					                            AUTO_MSGIN_02          );
				nsp32_reselected(SCpnt);
				return;
			}

			break;
		default:
			printk("phase chg/other phase?\n");
			printk("irq_stat=0x%x trans_stat=0x%x\n", irq_stat, trans_stat);
			show_busphase(busphase);
			break;
		}
		return;
	}


	printk("irq_stat=0x%x trans_stat=0x%x\n", irq_stat, trans_stat);

	switch (busphase) {
	case BUSPHASE_MESSAGE_OUT:
		printk("msgout\n");

		break;
	case BUSPHASE_MESSAGE_IN:
		printk("msgin\n");

		break;
	case BUSPHASE_STATUS:
		printk("status\n");

		break;
	default:
		printk("?/other phase?\n");
		show_busphase(busphase);
		break;
	}

	//printk("restart\n");


	nsp32_write2(base, COMMAND_CONTROL, CLEAR_CDB_FIFO_POINTER |
		     AUTOSCSI_RESTART       |
		     AUTO_MSGIN_00_OR_04    |
		     AUTO_MSGIN_02          /*|*/
		     /*AUTO_ATN*/);
	return;


}

#undef SPRINTF
#define SPRINTF(args...) \
        do { if(pos < buffer + length) pos += sprintf(pos, ## args); } while(0)
static int nsp32_proc_info(char  *buffer,
			   char **start,
			   off_t  offset,
			   int    length,
			   int    hostno,
			   int    inout)
{
	char *pos = buffer;
	int thislength;
	unsigned long flags;
	nsp32_hw_data *data = &nsp32_data;
	struct Scsi_Host *host = data->Host;
	unsigned int base = host->io_port;
	unsigned char mode_reg;

	if (inout) {
		return -EINVAL;
	}


	SPRINTF("NinjaSCSI32 status\n\n");
	SPRINTF("Driver version:        $Revision: 1.14 $\n");
	SPRINTF("SCSI host No.:         %d\n",          hostno);
	SPRINTF("IRQ:                   %d\n",          host->irq);
	SPRINTF("IO:                    0x%lx-0x%lx\n", host->io_port, host->io_port + host->n_io_port - 1);
	SPRINTF("MMIO(virtual address): 0x%lx\n",       host->base);
	SPRINTF("sg_tablesize:          %d\n",          host->sg_tablesize);
	SPRINTF("Chip revision:         %d\n",          (nsp32_read2(base, INDEX_REG) >> 8) - 0x4f);

	mode_reg = nsp32_index_read1(base, CHIP_MODE);

	SPRINTF("Power Management:      %s\n",          (mode_reg & OPTF) ? "yes" : "no");
	SPRINTF("OEM:                   %s\n",          nsp32_model[mode_reg & (OEM0|OEM1)]);

	spin_lock_irqsave(&(data->Lock), flags);
	SPRINTF("CurrentSC:             0x%p\n\n",      data->CurrentSC);
	spin_unlock_irqrestore(&(data->Lock), flags);

	thislength = pos - (buffer + offset);

	if(thislength < 0) {
		*start = 0;
                return 0;
        }


	thislength = MIN(thislength, length);
	*start = buffer + offset;

	return thislength;
}
#undef SPRINTF

static int nsp32_detect(Scsi_Host_Template *sht)
{
	struct Scsi_Host *host;	/* registered host structure */
	int ret;
	nsp32_hw_data *data = &nsp32_data;

//	DEBUG(0, __func__ "\n");

	host		  = scsi_register(sht, 0);
	host->irq         = data->IrqNumber;
	host->io_port	  = data->BaseAddress;
	host->unique_id	  = data->BaseAddress;
	host->n_io_port	  = data->NumAddress;
	host->base        = data->MmioAddress;

	data->Host        = host;

	spin_lock_init(&(data->Lock));

	scsi_set_pci_device(host, data->Pci);


//	data->autoparam   = kmalloc(4*15, GFP_ATOMIC);


	nsp32hw_init(host);

	snprintf(data->info_str, sizeof(data->info_str), "nsp32: irq %d, io 0x%lx+0x%x", host->irq, host->io_port, host->n_io_port);

	sht->name	  = data->info_str;

	ret = request_irq(host->irq, nsp32intr, SA_SHIRQ, "nsp32_cb", data);
	if (ret < 0) {
		printk("req irq fail\n");
		return 0;
	}

	MOD_INC_USE_COUNT;

	return 1;
}

static int nsp32_release(struct Scsi_Host *shpnt)
{
	nsp32_hw_data *data = &nsp32_data;

//	kfree(data->autoparam);

	DEBUG(0, "free irq\n");
	if (shpnt->irq)
		free_irq(shpnt->irq, data);

	DEBUG(0, "free io\n");
	if (shpnt->io_port && shpnt->n_io_port) {
		release_region(shpnt->io_port, shpnt->n_io_port);
	}

	MOD_DEC_USE_COUNT;

	return 0;
}

static const char *nsp32_info(struct Scsi_Host *shpnt)
{
	nsp32_hw_data *data = &nsp32_data;

//	printk(__func__ "\n");

	return data->info_str;
}


static int nsp32_reset(Scsi_Cmnd *SCpnt, unsigned int reset_flags)
{
	printk(__func__ " SCpnt=0x%p why=%d\n", SCpnt, reset_flags);

	nsp32_eh_bus_reset(SCpnt);

	return SCSI_RESET_SUCCESS | SCSI_RESET_BUS_RESET;
}


static int nsp32_eh_bus_reset(Scsi_Cmnd *SCpnt)
{
	unsigned int base = SCpnt->host->io_port;
	int	     i;

	printk(__func__ "()\n");

	nsp32_write2(base, IRQ_CONTROL, IRQ_CONTROL_ALL_IRQ_MASK);


	nsp32_write2(base, TRANSFER_CONTROL, 0);
	nsp32_write4(base, BM_CNT,           0);


	nsp32_write1(base, SCSI_BUS_CONTROL, BUSCTL_RST);
	mdelay(100);
	nsp32_write1(base, SCSI_BUS_CONTROL, 0);
	for(i = 0; i < 5; i++) {
                nsp32_read2(base, IRQ_STATUS); /* dummy read */
        }
	nsp32_write2(base, IRQ_CONTROL, 0);

	return SUCCESS;
}

static int nsp32_eh_host_reset(Scsi_Cmnd *SCpnt)
{
	struct Scsi_Host *host = SCpnt->host;

	printk(__func__ "()\n");

	nsp32hw_init(host);

	return SUCCESS;
}



static int __devinit nsp32_probe(struct pci_dev *pdev, const struct pci_device_id *id)
{
	int ret;
	nsp32_hw_data *data = &nsp32_data;
	unsigned short cmd_reg;

	DEBUG(0, __func__ " in\n");

        ret = pci_enable_device(pdev);
	if (ret) {
		DEBUG(0, "ret\n");
		return ret;
	}

	data->IrqNumber = pdev->irq;
	data->BaseAddress = pci_resource_start(pdev, 0);
	data->NumAddress = pci_resource_len(pdev, 0);
	data->MmioAddress = (unsigned long)ioremap_nocache(pci_resource_start(pdev, 1), pci_resource_len(pdev, 1));
	data->Pci = pdev;

	pci_read_config_word(pdev, PCI_COMMAND, &cmd_reg);
	cmd_reg |= PCI_COMMAND_MASTER;
	pci_write_config_word(pdev, PCI_COMMAND, cmd_reg);


#if (LINUX_VERSION_CODE > KERNEL_VERSION(2,5,2))
	scsi_register_host(&driver_template);
#else
	scsi_register_module(MODULE_SCSI_HA, &driver_template);
#endif

	printk(KERN_INFO "nsp32 cardbus at irq %i mmio 0x%lx\n", pdev->irq, data->MmioAddress);
	printk(KERN_INFO "slot:%s model:%s\n", pdev->slot_name, nsp32_model[id->driver_data]);

	DEBUG(0, __func__ " end\n");
	return 0;
}

static void __devexit nsp32_remove(struct pci_dev *pdev)
{
	nsp32_hw_data *data = &nsp32_data;

	DEBUG(0, __func__ " in\n");
	

#if (LINUX_VERSION_CODE > KERNEL_VERSION(2,5,2))
	scsi_unregister_host(&driver_template);
#else
	scsi_unregister_module(MODULE_SCSI_HA, &driver_template);
#endif

	if (data->MmioAddress != 0) {
		iounmap((void *)(data->MmioAddress));
	}
}

static struct pci_device_id nsp32_pci_table[] __devinitdata = {
	{
		vendor:      PCI_VENDOR_ID_IODATA,
		device:      PCI_DEVICE_ID_NINJASCSI_32BI_CBSC_II,
		subvendor:   PCI_ANY_ID,
		subdevice:   PCI_ANY_ID,
		driver_data: MODEL_IODATA,
	},
	{
		vendor:      PCI_VENDOR_ID_WORKBIT,
		device:      PCI_DEVICE_ID_NINJASCSI_32BI_KME,
		subvendor:   PCI_ANY_ID,
		subdevice:   PCI_ANY_ID,
		driver_data: MODEL_KME,
	},
	{
		vendor:      PCI_VENDOR_ID_WORKBIT,
		device:      PCI_DEVICE_ID_NINJASCSI_32BI_WBT,
		subvendor:   PCI_ANY_ID,
		subdevice:   PCI_ANY_ID,
		driver_data: MODEL_WORKBIT,
	},
	{
		vendor:      PCI_VENDOR_ID_WORKBIT,
		device:      PCI_DEVICE_ID_LOGITEC_TEST,
		subvendor:   PCI_ANY_ID,
		subdevice:   PCI_ANY_ID,
		driver_data: MODEL_EXP_ROM,
	},
	{
		vendor:      PCI_VENDOR_ID_WORKBIT,
		device:      PCI_DEVICE_ID_NINJASCSI_32BI_LOGITEC,
		subvendor:   PCI_ANY_ID,
		subdevice:   PCI_ANY_ID,
		driver_data: MODEL_EXP_ROM,
	},
	{
		vendor:      PCI_VENDOR_ID_WORKBIT,
		device:      PCI_DEVICE_ID_NINJASCSI_32BIB_LOGITEC,
		subvendor:   PCI_ANY_ID,
		subdevice:   PCI_ANY_ID,
		driver_data: MODEL_EXP_ROM,
	},
	{0,0,},
};
MODULE_DEVICE_TABLE(pci, nsp32_pci_table);

static struct pci_driver nsp32_driver = {
	name:        "nsp32_cb",
	id_table:    nsp32_pci_table,
	probe:       nsp32_probe,
	remove:      nsp32_remove,
/*	save_state:  nsp32_save_state,*/
/*	suspend:     nsp32_suspend,*/
/*	resume:      nsp32_resume,*/
/*	enable_wake: nsp32_eneble_wake,*/
};




static int __init init_nsp32_cb(void) {
	DEBUG(0, "%s\n", version);
	return pci_module_init(&nsp32_driver);
}

static void __exit exit_nsp32_cb(void) {
	DEBUG(0, "nsp32_cs: unloading\n");
	pci_unregister_driver(&nsp32_driver);
	DEBUG(0, __func__ " out\n");
}

module_init(init_nsp32_cb);
module_exit(exit_nsp32_cb);

