/*
  NinjaSCSI I/O funtions 
      By: YOKOTA Hiroshi <yokota@netlab.is.tsukuba.ac.jp>
 
  This software may be used and distributed according to the terms of
  the GNU Public License.

  */

/* $Id: nsp_io.c,v 1.2 2000/11/29 10:01:19 elca Exp $ */

static inline void nsp_write(unsigned int base,
			     unsigned int index,
			     unsigned char val)
{
	outb(val, (base + index));
}

static inline unsigned char nsp_read(unsigned int base,
				     unsigned int index)
{
	return inb(base + index);
}


/* index func */
static inline unsigned char nsp_index_read(unsigned int BaseAddr,
					   unsigned int Register)
{
	outb(Register, BaseAddr + INDEXREG);
	return inb(BaseAddr + DATAREG);
}

static inline void nsp_index_write(unsigned int BaseAddr,
				 unsigned int Register,
				 char Value)
{
	outb(Register, BaseAddr + INDEXREG);
	outb(Value, BaseAddr + DATAREG);
}

/* fifo func */
static inline void nsp_multi_read_1(unsigned int BaseAddr,
				    unsigned int Register,
				    unsigned char *buf,
				    unsigned long count)
{
	insb(BaseAddr + Register, buf, count);
}

static inline void nsp_fifo8_read(unsigned int base,
				  unsigned char *buf,
				  unsigned long count)
{
	//DEBUG(0, __FUNCTION__ "() buf=0x%p, count=0x%lx\n", buf, count);
	nsp_multi_read_1(base, FIFODATA, buf, count);
}

static inline void nsp_multi_write_1(unsigned int BaseAddr,
				     unsigned int Register,
				     unsigned char *buf,
				     unsigned long count)
{
	outsb(BaseAddr + Register, buf, count);
}

static inline void nsp_fifo8_write(unsigned int base,
				   unsigned char *buf,
				   unsigned long count)
{
	nsp_multi_write_1(base, FIFODATA, buf, count);
}

/* end */
