// $Id: ishadowmap.cpp,v 1.2 2001/06/18 07:33:48 elca Exp $

#include "ishadowmap.H"

#ifdef WIN32
#define TIMER_PERIOD	1
static MMRESULT resultTimeBeginPeriod ;
#endif

static GLint	width, height ;
static int		outputFPS ;
static GLint	texFilter ;

static float	bg0[] = { 0.0, 0.5, 1.0, 0.0 } ;
static float	bg1[] = { 0.0, 0.0, 0.0, 0.0 } ;
static float	bg[4] ;
static int		animationCount = 0 ;

static unsigned int glutBuff ;
static int		winIDglut = 0 ;

static int		dragL = FALSE, dragR = FALSE ;
static GLint 	dragX, dragY, mouseX, mouseY ;
static GLfloat	spinX = START_SPIN_X, spinY = START_SPIN_Y, mSpeed ;
static float	distance = 8, tdistance = 16 ;

static int		volumeLight = TRUE ;
static int		reflection = TRUE ;
static int		depthMask = TRUE ;
static int		fresnel = TRUE, perVertexFresnel ;
static float	visibility, reflectRatio[4] ;
static int		shadow ;
static int		canShadow = TRUE ;
static int		spotLight = TRUE ;
static int		gloss ;
static int		canGloss = TRUE ;

static int		pause_f = FALSE ;
static int		reconstShadowMapFlag = TRUE ;
static GLint	shadowTexFilter ;

static float	tHelpIntensity = 0.0 ;
static float	helpIntensity = 0.0 ;

static String title ;
static int		changeTitleWait = 0 ;

static const Vector3d csAxis(1.0, 0.0, -1.0), ctAxis(0.0, -1.0, 1.0) ;
static Vector3d	sAxis, tAxis ;

static int		viewPoint = -1 ;

// ե졼५
static unsigned int frameCount = 0 ;
static int			f_cnt = 0 ;
static float		fps ;
static String		str_fps ;
static String		str_status ;
static Vector3d		fps_position ;

static double		nTick, oTick, mSecStep, oldMSecStep ;
static double		timeRes ;

static GLfloat	lightpos[4] = { 0.0, 0.0, 0.0, 1.0 } ;
static GLfloat	plightpos[4] = { 0.0, 0.0, 1.0, 0.0 } ;
static GLfloat	lightdir[3] = { 0.0, 0.0, -1.0 } ;

// 饤ѥХ饤ȡʴĶѥǥ饤ȥ֥Τ߻ѡ
static GLfloat	alightpos[4] = { 0.0, 0.0, 1.0, 0.0 } ;
static GLfloat	alightcol[4] = { 1.0, 1.0, 1.0, 1.0 } ;

static GLfloat	s_plane[4] = { 1.0, 0.0, 0.0, 0.0 } ;
static GLfloat	t_plane[4] = { 0.0, 1.0, 0.0, 0.0 } ;
static GLfloat	q_plane[4] = { 0.0, 0.0, 1.0, 0.0 } ;

static GLfloat	ambient[4] = { 0.34, 0.34, 0.40, 1.0 } ;
static GLfloat	gambient[4] = { 0.5, 0.5, 0.5, 1.0 } ;
static GLfloat	nambient[4] = { 0.0, 0.0, 0.0, 1.0 } ;

static GLfloat	lightColor[MAX_MAX_LIGHTS][4] =
{
	{ 0.9, 0.9, 0.9, 1.0 },
	{ 0.9, 0.9, 0.9, 1.0 },
	{ 1.0, 0.3, 1.0, 1.0 },
	{ 0.3, 1.0, 0.4, 1.0 },

	{ 0.3, 0.3, 1.0, 1.0 },
	{ 1.0, 0.3, 0.3, 1.0 },
	{ 0.3, 1.0, 0.3, 1.0 },
} ;

static GLfloat	lightSourceColor[MAX_LIGHTS][4] ;

static GLfloat	lightObjectColor[MAX_MAX_LIGHTS][4] =
{
	{ 0.4, 1.0, 0.4, 1.0 },
	{ 1.0, 0.4, 1.0, 1.0 },
	{ 1.0, 0.9, 0.1, 1.0 },
	{ 0.4, 0.4, 1.0, 1.0 },

	{ 1.0, 0.4, 0.4, 1.0 },
	{ 0.4, 1.0, 0.4, 1.0 },
	{ 1.0, 0.4, 1.0, 1.0 },
} ;

static GLfloat	lightCenter[MAX_MAX_LIGHTS][3] =
{
	{  0.0,  0.0,  0.0 },
	{  0.0,  0.0,  0.0 },
	{  0.0,  0.0,  0.0 },
	{  0.0,  0.0,  0.0 },

	{  0.0,  0.0,  0.0 },
	{  0.0,  0.0,  0.0 },
	{  0.0,  0.0,  0.0 },
} ;


// ɸ
static Vector3d groundVertices[5] =
{
	Vector3d(-5.0, -5.0, -2.0),
	Vector3d( 5.0, -5.0, -2.0),
	Vector3d( 5.0,  5.0, -2.0),
	Vector3d(-5.0,  5.0, -2.0),

	Vector3d(-0.0,  0.0, -2.0),	// center
} ;

static int groundAlphaIndex = 12 ;
static int torusAlphaIndex  =  4 ;

static int torus2AlphaIndex = 50 ;


// ͱƹ󥻥åȡgluPerspectiveѤΥѥ᥿
static GLdouble	fov, aspectRatio, nearClip, farClip ;

static GLuint	OBJECT_LIST[MAX_OBJECTS], S_OBJECT_LIST[MAX_OBJECTS] ;
static GLuint	LIGHT_LIST, S_LIGHT_LIST, PARALLEL_LIGHT_LIST, S_PARALLEL_LIGHT_LIST ;
static GLuint	LIGHT_PLANE_LIST, PARALLEL_LIGHT_PLANE_LIST, LIGHT_SOURCE_PLANE_LIST, PARALLEL_LIGHT_SOURCE_PLANE_LIST ;
static GLuint	LIGHT_MATERIAL_LIST[MAX_LIGHTS] ;
static GLuint	STATUS_STRING_LIST ;
static GLuint	VOLUME_LIGHT_LIST[MAX_LIGHTS], R_VOLUME_LIGHT_LIST[MAX_LIGHTS] ;
static GLuint	PARALLEL_VOLUME_LIGHT_LIST[MAX_LIGHTS], R_PARALLEL_VOLUME_LIGHT_LIST[MAX_LIGHTS] ;
static GLuint	GROUND_LIST, V_GROUND_LIST, T_GROUND_LIST, TV_GROUND_LIST, S_GROUND_LIST ;
static GLuint	REFLECT_TRANSFORM_LIST, HELP_LIST ;

static GLuint	SPOT_TEXTURE[MAX_LIGHTS], PROJECT_TEXTURE[MAX_LIGHTS], SHADOW_TEXTURE[MAX_LIGHTS], SPOT_COPY_LIST ;
static GLuint	OBJECT_TEXTURE, FLOOR_TEXTURE, FLOOR_WITH_GLOSS_TEXTURE ;
static GLuint	HELP_TEXTURE ;

static GLuint	SHADOW_MAP_TEX_ENV_MODE_LIST, GLOSS_MAP_TEX_ENV_MODE_LIST ;

// ѹ
static GLfloat	controlObjectMatrix[16] ;

static ObjectStatus	world, object[MAX_OBJECTS] ;
static LightStatus	light[MAX_LIGHTS];
static int			nLights, nObjects ;

static float		lightPlaneSize, tLightPlaneSize ;

static char		*has_texture_env_combine ;
static char		*has_multitexture ;
static int		maxActiveTextures, maxTextureSize ;
static char		*has_texture_filter_anisotropic ;
static float	maxAnisotropy, currentAnisotropy ;

static GLint	stencilBits, alphaBits, bpp ;
static float	alphaRes, alphaBias ;

static String	glVendor, glRenderer, glVersion ;
static int		isTNT = FALSE ;
static int		activeTexGenerate, activeTexExplicit ;

static GLsizei	shadowTexWidth, shadowTexHeight ;

static int	activeRenderingLight ;


#if defined WIN32 && defined USE_PERFORMANCE_COUNTER
static int isSupportedPerformanceCount = -1 ;
#else	// #ifdef WIN32
static int isSupportedPerformanceCount = FALSE ;
#endif	// #ifdef WIN32 ... #else

static double mSecResolution ;

double GetErapsedTime()
{
	double msec = 0.0;

#if defined WIN32 && defined USE_PERFORMANCE_COUNTER
	static LARGE_INTEGER performanceCount ;

	if (isSupportedPerformanceCount == -1)v{
		static LARGE_INTEGER frequency ;
		isSupportedPerformanceCount = QueryPerformanceFrequency(&frequency) ;
		mSecResolution = (double)frequency.LowPart  / 1000.0 +
			(double)frequency.HighPart / 1000.0 * double(0xffffffffL) + 1.0 ;
	} else if (isSupportedPerformanceCount) {
		QueryPerformanceCounter(&performanceCount) ;
		msec = ((double)performanceCount.LowPart +
			(double)performanceCount.HighPart * double(0xffffffffL) + 1.0) / mSecResolution ;
	}

#endif	// #if defined WIN32 && defined USE_PERFORMANCE_COUNTER

	if (!isSupportedPerformanceCount) {
#if defined WIN32 && defined USE_TIME_GET_TIME
		msec = (double)timeGetTime() ;
#else
		msec = (double)glutGet((GLenum)GLUT_ELAPSED_TIME) ;
#endif
	}

	return msec ;
}

double MeasureTimerResolution()
{
	double msec = GetErapsedTime() ;
	double startTime = msec, last ;
	int count = 0 ;
	double interval = 0.0 ;

	if (isSupportedPerformanceCount) {
		interval = 1.0 / mSecResolution ;
	} else {
		while (msec - startTime < 5000.0 && startTime <= msec && count < 20) {
			count ++ ;
			last = msec ;

			while ((msec = GetErapsedTime()) == last) { ; }
			interval += msec - last ;	// ºݤѲ
		}

		if (startTime >= msec)
			interval = 0.0 ;

		if (count)
			interval /= count ;
	}

	return interval ;
}

// ߥñּ̻ͭʴֳ֤¬
double TimerResolution()
{
	double interval = MeasureTimerResolution() ;
	if (interval == 0.0) interval = MeasureTimerResolution() ;

	return interval ;
}


// Τν
STATUS Initialize(Option& option)
{
	srand( (unsigned)time( NULL ) );

	cout << VERSION_INFO << endl ;
	cout << AUTHOR << endl << endl ;

#ifdef WIN32
	resultTimeBeginPeriod = timeBeginPeriod(TIMER_PERIOD) ;
#endif	// #ifdef WIN32


	width  = option.GetInt("-width",  WIDTH,  2) ;
	height = option.GetInt("-height", HEIGHT, 2) ;

	int filter ;
	texFilter = NONE ;
	filter        = option.Get      ("-N",                       2) ;
	if (filter) texFilter = GL_NEAREST ;
	filter        = option.Get      ("-L",                       2) ;
	if (filter) texFilter = GL_LINEAR ;
	filter        = option.Get      ("-LL",                      3) ;
	if (filter) texFilter = GL_LINEAR_MIPMAP_LINEAR ;

	if (texFilter == NONE) texFilter = TEX_FILTER ;

	mSpeed        = option.GetDouble("-mspeed",   MOUSE_SPEED,   3) ;
	outputFPS     = option.Get      ("-FPS",                     2) ;

	glutBuff      = option.Get      ("-SINGLE",                  2) ;
	if (glutBuff) glutBuff = GLUT_SINGLE ;
	else          glutBuff = GLUT_DOUBLE ;

	// ǥեȤĺñ̤Υեͥ׻
	perVertexFresnel = option.GetInt("-vfresnel", PER_VERTEX_FRESNEL, 4) ;

	alphaBias = option.GetDouble("-abias", DEFAULT_ALPHA_BIAS) ;

	activeRenderingLight = -1 ;

	fps = 0.0 ;
	ObjectInitialize() ;

	sAxis = csAxis ;
	tAxis = ctAxis ;
	sAxis.Unit() ;
	tAxis.Unit() ;
	sAxis /= 3.0 ;
	tAxis /= 3.0 ;

	STATUS state ;
	state = OpenGLInitialize(option) ;

	timeRes = TimerResolution() ;
	nTick = GetErapsedTime() ;
	oTick = nTick ;
	mSecStep = oldMSecStep = 0.0 ;

	// ٤٤ƤưŬڤͤ򥻥å
	nLights = MAX_LIGHTS ;
	nObjects = MAX_OBJECTS ;
	MoveObjects() ;
	nLights = DEFAULT_LIGHTS ;
	nObjects = DEFAULT_OBJECTS ;

	return state ;
}


void ObjectInitialize()
{
	nLights = DEFAULT_LIGHTS ;
	nObjects = DEFAULT_OBJECTS ;

	tLightPlaneSize = LIGHT_PLANE_SIZE ;
	lightPlaneSize = LIGHT_PLANE_SIZE * 0.1f ;

	// Lights
	for (int i = 0 ; i < MAX_LIGHTS ; i ++)
	{
		float sign = (i % 2) * 2.0 - 1.0 ;	// -1, 1

		light[i].dbase = i * 0.5 + 7.0 ;

		light[i].angle2.Initialize(Random(360.0), Random(360.0), 0.0,
					   CRandom(1.0, 2.0), CRandom(1.0, 2.0), 0.0) ;
		light[i].angle.Initialize(Random(360.0), Random(360.0), Random(360.0),
					  CRandom(0.5, 1.0), Random(1.0, 3.0) * (sign), Random(1.0, 2.0) * (-sign)) ;

		// ƥɿå
		for (int c = 0 ; c < 3 ; c ++) {
			lightSourceColor[i][c] = lightColor[i][c] * 2.0 ;
			if (lightSourceColor[i][c] > 1.0) {
				lightSourceColor[i][c] = 1.0 ;
			}
		}
		lightSourceColor[i][3] = 1.0 ;
	}

	// World
	world.angle.Initialize(0.0, 0.0, 0.0,
			       0.0, 0.0, 1.0) ;

	// Objects
	for (int i = 0 ; i < MAX_OBJECTS ; i ++) {
		object[i].angle.Initialize(Random(360.0), Random(360.0), Random(360.0),
					   CRandom(0.5, 1.5), CRandom(0.5, 1.5), CRandom(0.5, 1.5)) ;
	}
}


void CheckColorBuffer()
{
	bpp = glutGet((GLenum)GLUT_WINDOW_BUFFER_SIZE) ;
	glGetIntegerv(GL_ALPHA_BITS, &alphaBits) ;
	glGetIntegerv(GL_STENCIL_BITS, &stencilBits) ;

	if (alphaBits < 4) {
		canShadow = FALSE ;

		String message = "Enough alpha plane is not supported (disable shadows)." ;
		cout << message << endl ;
	}

	if (alphaBits < 4) {
		canGloss = FALSE ;

		String message = "Enough alpha plane is not supported (disable gloss mapping)." ;
		cout << message << endl ;
	}

	if (canShadow && canGloss) {
		String message = NumToString(alphaBits) + " bits Alpha plane is supported." ;
		cout << message << endl ;
	}


	int tAlphaBits ;
	if      (alphaBits <=  8) { tAlphaBits =  8 ; }
	else if (alphaBits <= 12) { tAlphaBits = 12 ; }
	else			  { tAlphaBits = 16 ; }
	alphaRes = 1.0 / Pow(2, tAlphaBits) ;

	// Ȥꤢ
	stencilBits = 0 ;
}

void CheckOpenGLEnvironment()
{
	const char *glStr ;
	glStr = (const char *)glGetString(GL_VENDOR) ;
	if (glStr) glVendor = glStr ;
	glStr = (const char *)glGetString(GL_RENDERER) ;
	if (glStr) glRenderer = glStr ;
	glStr = (const char *)glGetString(GL_VERSION) ;
	if (glStr) glVersion = glStr ;

	String renderer = glRenderer ;
	renderer.Upper() ;
	if (renderer.Search("TNT"))
		isTNT = TRUE ;
}

STATUS CheckOpenGLExtensions()
{
	has_texture_env_combine = IsSupported_texture_env_combine() ;
	if (!has_texture_env_combine) {
		canShadow = FALSE ;
		canGloss = FALSE ;
		String message = "Texture env combine extension is not supported (disable shadows, gloss mapping)." ;
		cout << message << endl ;
	} else {
		String message = String(has_texture_env_combine) + " is supported." ;
		cout << message << endl ;
	}

	has_multitexture = IsSupported_multitexture() ;
	if (!has_multitexture) {
		String message = "Multi texture extension is required." ;
#ifdef WIN32
		MessageBox(NULL, message, _T("Initialize Failure"), MB_OK | MB_ICONSTOP) ;
#endif
		cerr << message << endl ;
		return FAILURE ;
	} else {
		String message = String(has_multitexture) + " is supported." ;
		cout << message << endl ;
		maxActiveTextures = GetMaxTextureUnits() ;
	}

	has_texture_filter_anisotropic = IsSupported_texture_filter_anisotropic() ;
	maxAnisotropy = GetMaxTextureMaxAnisotropy() ;
	if (has_texture_filter_anisotropic) {
		String message = String(has_texture_filter_anisotropic) + " (max anisotropy: " + NumToString(maxAnisotropy) + ")" + " is supported." ;
		cout << message << endl ;
	}

	if (maxAnisotropy >= 2.0)
		currentAnisotropy = 2.0 ;
	else
		currentAnisotropy = 1.0 ;

	// ƥκ祵
	glGetIntegerv(GL_MAX_TEXTURE_SIZE, &maxTextureSize) ;

	return SUCCESS ;
}


STATUS OpenGLInitialize(Option& option)
{
	STATUS state ;

	state = GLUTInitialize(option) ;
	if (state != SUCCESS)
		return state ;

	// Alpha plane, stencil bits
	CheckColorBuffer() ;

	CheckOpenGLEnvironment() ;

	if (isTNT) {
		shadowTexFilter = GL_NEAREST ;
		spotLight = FALSE ;

		activeTexGenerate = 1 ;
		activeTexExplicit = 0 ;
	} else {
		shadowTexFilter = GL_LINEAR ;

		activeTexGenerate = 1 ;
		activeTexExplicit = 0 ;
	}


	// OpenGL Extension
	state = CheckOpenGLExtensions() ;
	if (state != SUCCESS)
		return state ;

	if (!canShadow) {
		shadow = FALSE ;
		gloss  = FALSE ;

		String message = "At least 4 bits alpha plane and\n" ;
		message += "texture env combine extension\n" ;
		message += "is required for shadow and gloss mapping." ;

		if (alphaBits < 4 && bpp < 32)
			message += "\n32 bits display setting is recommended." ;

		cout << message << endl ;
#ifdef WIN32
		MessageBox(NULL, message, _T("Can't Enable some Effects"), MB_OK | MB_ICONEXCLAMATION) ;
#endif
	} else {
		shadow = TRUE ;		// ɥޥåײǽʤǥեȤ ON
		gloss  = TRUE ;		// ɥޥåײǽʤ饰ޥåפǽ
	}

	cout << endl ;

	SetGLUTCallback() ;		// GLUT ХåϿ
	SetupTextures(option) ;	// ƥ㥻åȥå
	DefineDisplayList() ;	// ǥץ쥤ꥹ

	InitializeLights() ;

	SetMiscParmeters() ;	// ¾

	return SUCCESS ;
}


void SetMiscParmeters()
{
//	glPolygonMode(GL_FRONT_AND_BACK, GL_LINE) ;
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL) ;


	// ꥢ
	glClearColor(bg[0], bg[1], bg[2], bg[3]) ;

	if (stencilBits)
		glClearStencil(0) ;

	glClearDepth(1.0) ;
	glDepthFunc(GL_LESS) ;

	glShadeModel(GL_SMOOTH) ;

	glFrontFace(GL_CCW) ;
	glEnable(GL_CULL_FACE) ;
	glCullFace(GL_BACK) ;

	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA) ;

	glMatrixMode(GL_MODELVIEW) ;
	glLoadIdentity() ;
	glPushMatrix() ;
	{
		glRotatef(-150.0, 1.0,0.0,0.0) ; // ž
//		glRotatef(0.0, 1.0,0.0,0.0) ; // ž
		glRotatef(-12.0, 0.0,1.0,0.0) ; // ž
		glGetFloatv(GL_MODELVIEW_MATRIX, controlObjectMatrix) ;
	}
	glPopMatrix() ;

	SetMaterial(GL_FRONT_AND_BACK, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0) ;

	// 顼ޥƥꥢΤߡ
	glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE) ;

	// for TNT
	glPolygonOffset(-0.5, -1.0) ;
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST) ;


	// 饤ѥХ饤ȡʴĶѥǥ饤ȥ֥Τ߻ѡ
	glMatrixMode(GL_MODELVIEW) ;
	glLoadIdentity() ;
	glPushMatrix() ;
	{
		SetDirectionalLight(GL_LIGHT7, alightpos, alightcol) ;
	}
	glPopMatrix() ;

	glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE) ;
	glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, GL_TRUE) ;

	glEnable(GL_DITHER) ;
	glDisable(GL_SCISSOR_TEST) ;

	SetAlphaBias() ;
}


void SetAlphaBias()
{
	// Alpha Func
	glAlphaFunc(GL_EQUAL, 0.5 + alphaBias * alphaRes) ;
}


// ƥǥץ쥤ꥹ
void DefineDisplayList()
{
	// 饤ȥ֥ȤΥǥץ쥤ꥹ
	DefineLightList() ;

	// ֥ȤΥꥹ
	DefineObjectLists() ;

	// Υǥץ쥤ꥹ
	DefineGroundList() ;

	// ɥޥåפ˥ݥåȥ饤
	DefineSpotCopyList() ;

	// ȿѴꥹ
	DefineReflectionTransformList() ;

	// ܥ塼饤ȥꥹ
	DefineVolumeLightLists() ;

	// إץåɽꥹ
	DefineHelpMessageList() ;

	// FPSѥǥץ쥤ꥹȡʳݤΤߡ
	AllocAList(STATUS_STRING_LIST) ;

	// Shadow Map ΥХʣơѡ
	DefineShadowMapTexEnvModeList() ;

	// Gloss Map ΥХʣơΤߡ
	DefineGlossMapTexEnvModeList() ;
}


void DefineShadowMapTexEnvModeList()
{
	glNewList(AllocAList(SHADOW_MAP_TEX_ENV_MODE_LIST), GL_COMPILE) ;
	{
		SetShwdowMappingTextureEnvMode() ;
	}
	glEndList() ;
}

void DefineGlossMapTexEnvModeList()
{
	glNewList(AllocAList(GLOSS_MAP_TEX_ENV_MODE_LIST), GL_COMPILE) ;
	{
		SetGlossMappingTextureEnvMode() ;
	}
	glEndList() ;
}


void RenderHelpMessage(float intensity)
{
	if (intensity <= 0.02)
		return ;

	glPushAttrib(GL_ALL_ATTRIB_BITS) ;
	{
		glMatrixMode(GL_TEXTURE) ;
//		glPushMatrix() ;
		glLoadIdentity() ;

		glMatrixMode(GL_PROJECTION) ;
//		glPushMatrix() ;
		glLoadIdentity() ;

		glMatrixMode(GL_MODELVIEW) ;
//		glPushMatrix() ;
		glLoadIdentity() ;

		{
			glDisable(GL_DEPTH_TEST) ;
			glDisable(GL_LIGHTING) ;

			glActiveTexture(activeTexGenerate + GL_TEXTURE0) ;
			glDisable(GL_TEXTURE_2D) ;

			glActiveTexture(activeTexExplicit + GL_TEXTURE0) ;
			glBindTexture(GL_TEXTURE_2D, HELP_TEXTURE) ;
			glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE) ;
			glEnable(GL_TEXTURE_2D) ;

			glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_COLOR) ;
			glEnable(GL_BLEND) ;

			// إʸ
			if (intensity >= 0.98) {
				glColor3f(intensity, intensity, intensity) ;
				glCallList(HELP_LIST) ;
			} else {
				for (int i = 0 ; i < 4 ; i ++) {
					float l = 0.38 ;

					glPushMatrix() ;
					{
						glTranslatef((i - 1.5) * (1.0 - intensity) * 0.1, 0.0, 0.0) ;
						glColor3f(intensity * l, intensity * l, intensity * l) ;
						glCallList(HELP_LIST) ;
					}
					glPopMatrix() ;
				}
			}
		}

		glMatrixMode(GL_TEXTURE) ;
//		glPopMatrix() ;

		glMatrixMode(GL_PROJECTION) ;
//		glPopMatrix() ;

		glMatrixMode(GL_MODELVIEW) ;
//		glPopMatrix() ;
	}
	glPopAttrib() ;
}

void DefineHelpMessageList()
{
	glNewList(AllocAList(HELP_LIST), GL_COMPILE) ;
	{
		// إʸ
		glBegin(GL_QUADS) ;
		{
			glTexCoord2f(0.0, 0.0) ;
			glVertex2f(-0.9, -0.9) ;

			glTexCoord2f(1.0, 0.0) ;
			glVertex2f( 0.9, -0.9) ;

			glTexCoord2f(1.0, 1.0) ;
			glVertex2f( 0.9,  0.9) ;

			glTexCoord2f(0.0, 1.0) ;
			glVertex2f(-0.9,  0.9) ;
		}
		glEnd() ;
	}
	glEndList() ;
}

void DefineSpotCopyList()
{
	glNewList(AllocAList(SPOT_COPY_LIST), GL_COMPILE) ;
	{
		glMatrixMode(GL_MODELVIEW) ;
		glLoadIdentity() ;	// clear modelview matrix
		glMatrixMode(GL_PROJECTION) ;
		glLoadIdentity() ;

		glColor3f(1.0, 1.0, 1.0) ;
		glBegin(GL_QUADS) ;
		{
			glTexCoord2f(0.0, 0.0) ;
			glVertex2f(-1.0, -1.0) ;

			glTexCoord2f(1.0, 0.0) ;
			glVertex2f(1.0, -1.0) ;

			glTexCoord2f(1.0, 1.0) ;
			glVertex2f(1.0, 1.0) ;

			glTexCoord2f(0.0, 1.0) ;
			glVertex2f(-1.0, 1.0) ;
		}
		glEnd() ;
	}
	glEndList() ;
}

void DefineObjectLists()
{
	DefineObject0List(0) ;
	DefineObject1List(3) ;
	DefineObject2List(2) ;
	DefineObject3List(1) ;
//	DefineObject4List(4) ;
}


void Draw3Cylinders(float radius, int alphaStartIndex, int shadowFlag)
{
	GLfloat color[4] = { 1.0, 1.0, 1.0, 0.0 } ;
	GLfloat cylnderRadius = radius * 0.2 ;

	// 3 Cylinders
	glPushMatrix() ;
	{
		glTranslatef(-0.8, 0.0, 0.0) ;
		for (int i = 0 ; i < 3 ; i ++) {
			if (i) {
				glTranslatef(0.8, 0.0, 0.0) ;
			}

			color[3] = (alphaStartIndex + i) * alphaRes ;
			glColor4fv(color) ;
			if (!shadowFlag) {
				Cylinder::DrawPolyhedron(16, cylnderRadius, TRUE,
							 cylnderRadius, TRUE,
							 radius, TRUE,
							 activeTexExplicit,
							 sAxis.v, tAxis.v) ;
			} else {
				Cylinder::DrawPolyhedron(16, cylnderRadius + SHADOW_MAPPING_EDGE_FAT_MIN, TRUE,
							 cylnderRadius + SHADOW_MAPPING_EDGE_FAT_MIN, TRUE,
							 radius + SHADOW_MAPPING_EDGE_FAT_MIN, FALSE) ;
			}
		}
	}
	glPopMatrix() ;
}

void DrawObject0(float radius, int alphaStartIndex, int shadowFlag)
{
	GLfloat color[4] = { 1.0, 1.0, 1.0, 0.0 } ;
	int alpha ;

	glPushMatrix() ;
	{
		alpha = 0 ;
		glTranslatef(0.0, -radius * 0.2, 0.0) ;
		Draw3Cylinders(radius, alphaStartIndex + alpha, shadowFlag) ;

		alpha = 3 ;
		glTranslatef(0.0, -radius * 0.6, 0.0) ;
		glRotatef(90.0, 0.0, 1.0, 0.0) ;
		Draw3Cylinders(radius, alphaStartIndex + alpha, shadowFlag) ;
	}
	glPopMatrix() ;

	glPushMatrix() ;
	{
		alpha = 6 ;
		color[3] = (alphaStartIndex + alpha) * alphaRes ;
		glColor4fv(color) ;

		glTranslatef(0.0, radius * 0.8, 0.0) ;

		float r = radius * 0.7 ;
		if (!shadowFlag) {
			Octahedron obj(r, r, r, 1, TRUE, FALSE) ;
			obj.Draw(NONE, NONE, FALSE, TRUE, activeTexExplicit, sAxis.v, tAxis.v) ;
		} else {
			Octahedron obj(r + SHADOW_MAPPING_EDGE_FAT_MIN,
				       r + SHADOW_MAPPING_EDGE_FAT_MIN,
				       r + SHADOW_MAPPING_EDGE_FAT_MIN, 1, TRUE, TRUE) ;
			obj.Draw(NONE, NONE, FALSE, FALSE) ;
		}
	}
	glPopMatrix() ;
}


void DefineObject0List(int obj)
{
	float radius = 1.2 ;
	glNewList(AllocAList(OBJECT_LIST[obj]), GL_COMPILE) ;
	{
		glPushAttrib(GL_COLOR_MATERIAL | GL_COLOR_MATERIAL_FACE) ;
		{
			glColorMaterial(GL_FRONT, GL_DIFFUSE) ;
			glEnable(GL_COLOR_MATERIAL) ;

			DrawObject0(radius, torusAlphaIndex) ;
		}
		glPopAttrib() ;
	}
	glEndList() ;

	glNewList(AllocAList(S_OBJECT_LIST[obj]), GL_COMPILE) ;
	{
		DrawObject0(radius, torusAlphaIndex, TRUE) ;
	}
	glEndList() ;
}

void DefineObject4List(int obj)
{
	float radius = 1.0 ;
	glNewList(AllocAList(OBJECT_LIST[obj]), GL_COMPILE) ;
	{
		glPushAttrib(GL_COLOR_MATERIAL | GL_COLOR_MATERIAL_FACE) ;
		{
			glColorMaterial(GL_FRONT, GL_DIFFUSE) ;
			glEnable(GL_COLOR_MATERIAL) ;
			Torus obj(0.45 * radius, 1.0 * radius, 6, 8, FALSE, FALSE) ;
			obj.DrawObjectWithAlphaIndex(TRUE, Vector3d::white, torus2AlphaIndex,alphaRes, sAxis.v, tAxis.v) ;
		}
		glPopAttrib() ;
	}
	glEndList() ;

	glNewList(AllocAList(S_OBJECT_LIST[obj]), GL_COMPILE) ;
	{
		Torus obj(0.45 * radius - SHADOW_MAPPING_EDGE_FAT, 1.0 * radius + SHADOW_MAPPING_EDGE_FAT_TORUS_OUTER, 16, 32, FALSE, FALSE) ;
		obj.DrawObjectWithAlphaIndex(TRUE, Vector3d::white, torus2AlphaIndex,alphaRes, sAxis.v, tAxis.v) ;
	}
	glEndList() ;
}

void DefineObject1List(int obj)
{
	GLfloat color[4] = { 1.0, 1.0, 1.0, 0 * alphaRes } ;

	float radius = 1.0 ;
	glNewList(AllocAList(OBJECT_LIST[obj]), GL_COMPILE) ;
	{
		glMaterialfv(GL_FRONT, GL_DIFFUSE, color) ;
		Icosahedron obj(radius, radius, radius, 2, TRUE, TRUE) ;
		obj.Draw(NONE, NONE, FALSE, TRUE, activeTexExplicit, sAxis.v, tAxis.v) ;
	}
	glEndList() ;

	glNewList(AllocAList(S_OBJECT_LIST[obj]), GL_COMPILE) ;
	{
		glColor4fv(color) ;
		Icosahedron obj(radius + SHADOW_MAPPING_EDGE_FAT,
				radius + SHADOW_MAPPING_EDGE_FAT,
				radius + SHADOW_MAPPING_EDGE_FAT, 2, TRUE, TRUE) ;
		obj.Draw(NONE, NONE, FALSE, FALSE) ;
	}
	glEndList() ;
}

void DefineObject2List(int obj)
{
	GLfloat color[4] = { 1.0, 1.0, 1.0, 1 * alphaRes } ;

	float radius = 0.9 ;
	glNewList(AllocAList(OBJECT_LIST[obj]), GL_COMPILE) ;
	{
		glMaterialfv(GL_FRONT, GL_DIFFUSE, color) ;
//		Octahedron::DrawPolyhedron(radius, TRUE, activeTexExplicit, sAxis.v, tAxis.v) ;
		Cylinder::DrawPolyhedron(32, radius * 0.6f, TRUE, radius, TRUE, radius * 0.8, TRUE, activeTexExplicit, sAxis.v, tAxis.v) ;
	}
	glEndList() ;

	glNewList(AllocAList(S_OBJECT_LIST[obj]), GL_COMPILE) ;
	{
		glColor4fv(color) ;
//		Octahedron::DrawPolyhedron(radius + SHADOW_MAPPING_EDGE_FAT, FALSE, activeTexExplicit, sAxis.v, tAxis.v) ;
		Cylinder::DrawPolyhedron(32, (radius + SHADOW_MAPPING_EDGE_FAT) * 0.6, TRUE,
					 radius + SHADOW_MAPPING_EDGE_FAT, TRUE,
					 radius * 0.8 + SHADOW_MAPPING_EDGE_FAT, TRUE, activeTexExplicit, sAxis.v, tAxis.v) ;
	}
	glEndList() ;
}

void DefineObject3List(int obj)
{
	GLfloat color[4] = { 1.0, 1.0, 1.0, 2 * alphaRes } ;

	float radius = 1.0 ;
	glNewList(AllocAList(OBJECT_LIST[obj]), GL_COMPILE) ;
	{
		glMaterialfv(GL_FRONT, GL_DIFFUSE, color) ;
		Icosahedron::DrawPolyhedron(radius, TRUE, activeTexExplicit, sAxis.v, tAxis.v) ;
	}
	glEndList() ;

	glNewList(AllocAList(S_OBJECT_LIST[obj]), GL_COMPILE) ;
	{
		glColor4fv(color) ;
		Icosahedron::DrawPolyhedron(radius + SHADOW_MAPPING_EDGE_FAT, FALSE, activeTexExplicit, sAxis.v, tAxis.v) ;
	}
	glEndList() ;
}


// ȿѴꥹ
void DefineReflectionTransformList()
{
	glNewList(AllocAList(REFLECT_TRANSFORM_LIST), GL_COMPILE) ;
	{
		// ؤαǤꤳȿž
		glRotatef(90.0, 1.0, 0.0, 0.0) ;
		glTranslatef(0.0, 0.0, -2.0) ;
		glScalef(1.0, 1.0, -1.0) ;
		glTranslatef(0.0, 0.0, 2.0) ;
		glRotatef(-90.0, 1.0, 0.0, 0.0) ;
	}
	glEndList() ;
}


// ܥ塼饤ȥꥹ
void DefineVolumeLightLists()
{
	for (int i = 0 ; i < MAX_LIGHTS ; i ++) {
		DefineVolumeLightList(i) ;
	}
}

void DefineVolumeLightList(int lNo)
{
	glNewList(AllocAList(VOLUME_LIGHT_LIST[lNo]), GL_COMPILE) ;
	{
		DrawPerspectiveVolumeLight(lNo, VOLUME_LIGHT_INTENSITY) ;
	}
	glEndList() ;

	glNewList(AllocAList(R_VOLUME_LIGHT_LIST[lNo]), GL_COMPILE) ;
	{
		DrawPerspectiveVolumeLight(lNo, VOLUME_LIGHT_INTENSITY_REF) ;
	}
	glEndList() ;


	glNewList(AllocAList(PARALLEL_VOLUME_LIGHT_LIST[lNo]), GL_COMPILE) ;
	{
		DrawParallelVolumeLight(lNo, VOLUME_LIGHT_INTENSITY) ;
	}
	glEndList() ;

	glNewList(AllocAList(R_PARALLEL_VOLUME_LIGHT_LIST[lNo]), GL_COMPILE) ;
	{
		DrawParallelVolumeLight(lNo, VOLUME_LIGHT_INTENSITY_REF) ;
	}
	glEndList() ;
}

void DrawPerspectiveVolumeLight(int lNo, float intensity)
{
	glBegin(GL_QUADS) ;
	{
		float step = 1.0 / ((NM_VOLUME_LIGHT_PLANES + 2) - 1) ;
		intensity *= 1.0 / NM_VOLUME_LIGHT_PLANES ;

		for (int u = 0 ; u < NM_VOLUME_LIGHT_PLANES ; u ++)
		{
			float base = (u - (NM_VOLUME_LIGHT_PLANES - 1) * 0.5) * step * 2.0 ;
			float farPlaneScale = Cos(VOLUME_LIGHT_FORCE_SPOT_FOV * ((u - (NM_VOLUME_LIGHT_PLANES - 1) * 0.5) / NM_VOLUME_LIGHT_PLANES)) ;

			glColor3f(lightColor[lNo][0] * intensity, lightColor[lNo][1] * intensity, lightColor[lNo][2] * intensity) ;
			glVertex3f(base * VOLUME_LIGHT_NEAR_PLANE,  VOLUME_LIGHT_NEAR_PLANE, -VOLUME_LIGHT_NEAR_PLANE) ;
			glVertex3f(base * VOLUME_LIGHT_NEAR_PLANE, -VOLUME_LIGHT_NEAR_PLANE, -VOLUME_LIGHT_NEAR_PLANE) ;
			glColor3f(0.0, 0.0, 0.0) ;
			glVertex3f(base * VOLUME_LIGHT_FAR_PLANE * farPlaneScale, -VOLUME_LIGHT_FAR_PLANE * farPlaneScale, -VOLUME_LIGHT_FAR_PLANE * farPlaneScale) ;
			glVertex3f(base * VOLUME_LIGHT_FAR_PLANE * farPlaneScale,  VOLUME_LIGHT_FAR_PLANE * farPlaneScale, -VOLUME_LIGHT_FAR_PLANE * farPlaneScale) ;
		}

		for (int v = 0 ; v < NM_VOLUME_LIGHT_PLANES ; v ++) {
			float base = (v - (NM_VOLUME_LIGHT_PLANES - 1) * 0.5) * step * 2.0 ;
			float farPlaneScale = Cos(VOLUME_LIGHT_FORCE_SPOT_FOV * ((v - (NM_VOLUME_LIGHT_PLANES - 1) * 0.5) / NM_VOLUME_LIGHT_PLANES)) ;

			glColor3f(lightColor[lNo][0] * intensity, lightColor[lNo][1] * intensity, lightColor[lNo][2] * intensity) ;
			glVertex3f(-VOLUME_LIGHT_NEAR_PLANE, base * VOLUME_LIGHT_NEAR_PLANE, -VOLUME_LIGHT_NEAR_PLANE) ;
			glVertex3f( VOLUME_LIGHT_NEAR_PLANE, base * VOLUME_LIGHT_NEAR_PLANE, -VOLUME_LIGHT_NEAR_PLANE) ;
			glColor3f(0.0, 0.0, 0.0) ;
			glVertex3f( VOLUME_LIGHT_FAR_PLANE * farPlaneScale, base * VOLUME_LIGHT_FAR_PLANE * farPlaneScale, -VOLUME_LIGHT_FAR_PLANE * farPlaneScale) ;
			glVertex3f(-VOLUME_LIGHT_FAR_PLANE * farPlaneScale, base * VOLUME_LIGHT_FAR_PLANE * farPlaneScale, -VOLUME_LIGHT_FAR_PLANE * farPlaneScale) ;
		}
	}
	glEnd() ;

//	CheckOpenGLError() ;
}

void DrawParallelVolumeLight(int lNo, float intensity)
{
	glBegin(GL_QUADS) ;
	{
		float step = 1.0 / ((NM_VOLUME_LIGHT_PLANES + 2) - 1) ;
		intensity *= 1.0 / NM_VOLUME_LIGHT_PLANES ;

		for (int u = 0 ; u < NM_VOLUME_LIGHT_PLANES ; u ++) {
			float base = (u - (NM_VOLUME_LIGHT_PLANES - 1) * 0.5) * step * 2.0 ;
			glColor3f(lightColor[lNo][0] * intensity, lightColor[lNo][1] * intensity, lightColor[lNo][2] * intensity) ;
			glVertex3f(base * LIGHT_PARALLEL_SCALE,  1.0 * LIGHT_PARALLEL_SCALE, -VOLUME_LIGHT_NEAR_PLANE) ;
			glVertex3f(base * LIGHT_PARALLEL_SCALE, -1.0 * LIGHT_PARALLEL_SCALE, -VOLUME_LIGHT_NEAR_PLANE) ;
			glColor3f(0.0, 0.0, 0.0) ;
			glVertex3f(base * LIGHT_PARALLEL_SCALE, -1.0 * LIGHT_PARALLEL_SCALE, -VOLUME_LIGHT_FAR_PLANE) ;
			glVertex3f(base * LIGHT_PARALLEL_SCALE,  1.0 * LIGHT_PARALLEL_SCALE, -VOLUME_LIGHT_FAR_PLANE) ;
		}

		for (int v = 0 ; v < NM_VOLUME_LIGHT_PLANES ; v ++) {
			float base = (v - (NM_VOLUME_LIGHT_PLANES - 1) * 0.5) * step * 2.0 ;
			glColor3f(lightColor[lNo][0] * intensity, lightColor[lNo][1] * intensity, lightColor[lNo][2] * intensity) ;
			glVertex3f(-1.0 * LIGHT_PARALLEL_SCALE, base * LIGHT_PARALLEL_SCALE, -VOLUME_LIGHT_NEAR_PLANE) ;
			glVertex3f( 1.0 * LIGHT_PARALLEL_SCALE, base * LIGHT_PARALLEL_SCALE, -VOLUME_LIGHT_NEAR_PLANE) ;
			glColor3f(0.0, 0.0, 0.0) ;
			glVertex3f( 1.0 * LIGHT_PARALLEL_SCALE, base * LIGHT_PARALLEL_SCALE, -VOLUME_LIGHT_FAR_PLANE) ;
			glVertex3f(-1.0 * LIGHT_PARALLEL_SCALE, base * LIGHT_PARALLEL_SCALE, -VOLUME_LIGHT_FAR_PLANE) ;
		}
	}
	glEnd() ;

//	CheckOpenGLError() ;
}


// ֥ȤΥǥץ쥤ꥹ
void DefineLightList()
{
	glNewList(AllocAList(LIGHT_LIST), GL_COMPILE) ;
	{
		glPushMatrix() ;
		{
			glTranslatef(0.0, 0.0, -(VOLUME_LIGHT_NEAR_PLANE * 0.25 * 3.0)) ;
			Cylinder::DrawPolyhedron(LIGHT_STACK, VOLUME_LIGHT_NEAR_PLANE * 0.5, TRUE, VOLUME_LIGHT_NEAR_PLANE, FALSE, VOLUME_LIGHT_NEAR_PLANE * 0.25, TRUE) ;
		}
		glPopMatrix() ;
	}
	glEndList() ;

	glNewList(AllocAList(S_LIGHT_LIST), GL_COMPILE) ;
	{
			glTranslatef(0.0, 0.0, -(VOLUME_LIGHT_NEAR_PLANE * 0.25 * 3.0)) ;
			Cylinder::DrawPolyhedron(LIGHT_STACK, VOLUME_LIGHT_NEAR_PLANE * 0.5, TRUE, VOLUME_LIGHT_NEAR_PLANE, TRUE, VOLUME_LIGHT_NEAR_PLANE * 0.25, TRUE) ;
	}
	glEndList() ;


	glNewList(AllocAList(PARALLEL_LIGHT_LIST), GL_COMPILE) ;
	{
		glPushMatrix() ;
		{
			glTranslatef(0.0, 0.0, -(VOLUME_LIGHT_NEAR_PLANE * 0.25 * 3.0)) ;
			Cylinder::DrawPolyhedron(LIGHT_STACK, 1.0 * LIGHT_PARALLEL_SCALE, TRUE, 1.0 * LIGHT_PARALLEL_SCALE, FALSE, VOLUME_LIGHT_NEAR_PLANE * 0.25, TRUE) ;
		}
		glPopMatrix() ;
	}
	glEndList() ;

	glNewList(AllocAList(S_PARALLEL_LIGHT_LIST), GL_COMPILE) ;
	{
			glTranslatef(0.0, 0.0, -(VOLUME_LIGHT_NEAR_PLANE * 0.25 * 3.0)) ;
			Cylinder::DrawPolyhedron(LIGHT_STACK, 1.0 * LIGHT_PARALLEL_SCALE, TRUE, 1.0 * LIGHT_PARALLEL_SCALE, TRUE, VOLUME_LIGHT_NEAR_PLANE * 0.25, TRUE) ;
	}
	glEndList() ;


	glNewList(AllocAList(LIGHT_PLANE_LIST), GL_COMPILE) ;
	{
		DrawLightPlane(LIGHT_STACK, VOLUME_LIGHT_NEAR_PLANE, -VOLUME_LIGHT_NEAR_PLANE) ;
	}
	glEndList() ;

	glNewList(AllocAList(PARALLEL_LIGHT_PLANE_LIST), GL_COMPILE) ;
	{
		DrawLightPlane(LIGHT_STACK, 1.0 * LIGHT_PARALLEL_SCALE, -VOLUME_LIGHT_NEAR_PLANE) ;
	}
	glEndList() ;


	glNewList(AllocAList(LIGHT_SOURCE_PLANE_LIST), GL_COMPILE) ;
	{
		DrawLightSourcePlane(LIGHT_STACK, VOLUME_LIGHT_NEAR_PLANE * 0.84, -VOLUME_LIGHT_NEAR_PLANE * 0.85) ;
	}
	glEndList() ;

	glNewList(AllocAList(PARALLEL_LIGHT_SOURCE_PLANE_LIST), GL_COMPILE) ;
	{
		DrawLightSourcePlane(LIGHT_STACK, 0.99 * LIGHT_PARALLEL_SCALE, -VOLUME_LIGHT_NEAR_PLANE * 0.75) ;
	}
	glEndList() ;


	for (int i = 0 ; i < MAX_LIGHTS ; i ++) {
		glNewList(AllocAList(LIGHT_MATERIAL_LIST[i]), GL_COMPILE) ;
		{
			SetMaterial(GL_FRONT, lightObjectColor[i][0], lightObjectColor[i][1], lightObjectColor[i][2], 1.0, 0.85, 1.0, 16.0) ;
			SetMaterial(GL_BACK, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) ;
			glMaterialfv(GL_BACK, GL_EMISSION, lightColor[i]) ;
		}
		glEndList() ;
	}
}


void DrawLightPlane(int div, float radius, float z)
{
	glBegin(GL_TRIANGLE_FAN) ;
	{
		// Center
		glTexCoord2f(0.5, 0.5) ;
		glVertex3f(0.0, 0.0, z) ;

		for (int i = 0 ; i <= div ; i ++)
		{
			int		r = (i % div) ;
			float	deg = r * 360.0 / div ;
			float	s = Sin(deg), c = Cos(deg) ;

			TexCoord2f(-s * 0.5 + 0.5, -c * 0.5 + 0.5, activeTexExplicit) ;
			glVertex3f(s * radius, c * radius, z) ;
		}
	}
	glEnd() ;
}


// ̡
// ǥƥʤ
// ˡ΢
void DrawLightSourcePlane(int div, float radius, float z)
{
	glBegin(GL_TRIANGLE_FAN) ;
	{
		// Center
		glVertex3f(0.0, 0.0, z) ;

		for (int i = 0 ; i <= div ; i ++) {
			int		r = (i % div) ;
			float	deg = r * 360.0 / div ;
			float	s = Sin(deg), c = Cos(deg) ;

			glVertex3f(s * radius, c * radius, z) ;
		}
	}
	glEnd() ;
}


void DefineGroundList()
{
	// GROUND_LIST, S_GROUND_LIST Ϧǥդ
	GLfloat color[4] = { 1.0, 1.0, 1.0, groundAlphaIndex * alphaRes } ;

	glNewList(AllocAList(GROUND_LIST), GL_COMPILE) ;
	{
		glMaterialfv(GL_FRONT, GL_DIFFUSE, color) ;
		DrawGround() ;
	}
	glEndList() ;

	glNewList(AllocAList(V_GROUND_LIST), GL_COMPILE) ;
	{
		DrawGround(TRUE) ;
	}
	glEndList() ;

	// ɥޥåѡʾ礭
	glNewList(AllocAList(S_GROUND_LIST), GL_COMPILE) ;
	{
		glPushMatrix() ;
		{
			glScalef(1.05, 1.051, 1.0) ;
			glColor4fv(color) ;
			DrawGround(TRUE, NULL, NULL, NULL, NULL, TRUE) ;
		}
		glPopMatrix() ;
	}
	glEndList() ;

	glNewList(AllocAList(T_GROUND_LIST), GL_COMPILE) ;
	{
		glPushMatrix() ;
		{
			glRotatef(90.0, 1.0, 0.0, 0.0) ;
			DrawGround() ;
		}
		glPopMatrix() ;
	}
	glEndList() ;

	// Ǥꤳߥޥ
	glNewList(AllocAList(TV_GROUND_LIST), GL_COMPILE) ;
	{
		glPushMatrix() ;
		{
			glRotatef(90.0, 1.0, 0.0, 0.0) ;
			DrawGround(TRUE) ;
		}
		glPopMatrix() ;
	}
	glEndList() ;
}


void DrawGround(int vFlag,
		float *color0,
		float *color1,
		float *color2,
		float *color3,
		int shadowObj)
{
	glBegin(GL_QUADS) ;
	{
		if (!vFlag) {
			glNormal3f(0.0, 0.0, 1.0) ;
			TexCoord2f(0.0, 0.0, activeTexExplicit) ;
		}
		if (color0) glColor4fv(color0) ;
		glVertex3fv(groundVertices[0].v) ;

		if (!vFlag) {
			TexCoord2f(2.0, 0.0, activeTexExplicit) ;
		}
		if (color1) glColor4fv(color1) ;
		glVertex3fv(groundVertices[1].v) ;

		if (!vFlag) {
			TexCoord2f(2.0,  2.0, activeTexExplicit) ;
		}
		if (color2) glColor4fv(color2) ;
		glVertex3fv(groundVertices[2].v) ;

		if (!vFlag) {
			TexCoord2f(0.0,  2.0, activeTexExplicit) ;
		}
		if (color3) glColor4fv(color3) ;
		glVertex3fv(groundVertices[3].v) ;
	}
	glEnd() ;
}


// դƥΥåȥå
void SetupTexture2DWithAlpha(const String& file, const String& alphaFile, GLint wrap, GLint filter)
{
	// ppm ɤ߹
	if (file != "")
	{
		TRUEIMAGE *image, *alpha ;
		LoadTextureImage(&image, file) ;
		LoadTextureImage(&alpha, alphaFile) ;

		RGBtoRGBA(image, alpha) ;
		SetTextureImage(image, "RGBA", 4) ;
//		gluBuild2DMipmaps(GL_TEXTURE_2D, 4, image->width, image->height, GL_RGBA, GL_UNSIGNED_BYTE, image->dataptr) ;

		freeimage(image) ;
		freeimage(alpha) ;
	}

	// åץå
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, wrap) ;
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, wrap) ;

	// ƥե륿å
	SetTextureFilter(filter) ;
}

// ΥƥΥåȥå
void SetupTexture2D(const String& file, GLint wrap, GLint filter)
{
	// ppm ɤ߹
	if (file != "")
	{
		TRUEIMAGE *image ;
		LoadTextureImage(&image, file) ;
		SetTextureImage(image) ;
		freeimage(image) ;
	}

	// åץå
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, wrap) ;
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, wrap) ;

	// ƥե륿å
	SetTextureFilter(filter) ;
}


// ƥΥåȥå
void SetupTextures(Option& option)
{
	// ݥåȥƥ
	glBindTexture(GL_TEXTURE_2D, AllocATexture(SPOT_TEXTURE[0])) ;
	SetupTexture2D(SPOT_IMAGE_FILE, GL_CLAMP, GL_LINEAR) ;

	// ݥåȥƥ
	glBindTexture(GL_TEXTURE_2D, AllocATexture(SPOT_TEXTURE[1])) ;
	SetupTexture2D(SPOT2_IMAGE_FILE, GL_CLAMP, GL_LINEAR) ;

	for (int i = 2 ; i < MAX_LIGHTS ; i ++)
		SPOT_TEXTURE[i] = SPOT_TEXTURE[i % 2] ;

	for (int i = 0 ; i < MAX_LIGHTS ; i ++)
		SHADOW_TEXTURE[i] = 0 ;
	InitializeShadowTextures() ;

	// ֥ȥƥ
	glBindTexture(GL_TEXTURE_2D, AllocATexture(OBJECT_TEXTURE)) ;
	SetupTexture2D(OBJECT_IMAGE_FILE, GL_REPEAT, texFilter) ;

	// եƥ
	glBindTexture(GL_TEXTURE_2D, AllocATexture(FLOOR_TEXTURE)) ;
	SetupTexture2D(FLOOR_IMAGE_FILE, GL_REPEAT, texFilter) ;

	// Ѧդեƥ
	glBindTexture(GL_TEXTURE_2D, AllocATexture(FLOOR_WITH_GLOSS_TEXTURE)) ;
	SetupTexture2DWithAlpha(FLOOR_IMAGE_FILE, GLOSS_IMAGE_FILE, GL_REPEAT, texFilter) ;


	// إץƥ
	glBindTexture(GL_TEXTURE_2D, AllocATexture(HELP_TEXTURE)) ;
	SetupTexture2D(HELP_IMAGE_FILE, GL_CLAMP, texFilter) ;

	// TEXTURE1 
	glActiveTexture(activeTexGenerate + GL_TEXTURE0) ;
	glTexGenf(GL_S, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR) ;
	glTexGenf(GL_T, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR) ;
	glTexGenf(GL_Q, GL_TEXTURE_GEN_MODE, GL_EYE_LINEAR) ;
	glActiveTexture(activeTexExplicit + GL_TEXTURE0) ;

	SetAllTexturesMaxAnisotropy(currentAnisotropy) ;
}

void SetTextureProjectionMatrix()
{
//	glPushAttrib(GL_MATRIX_MODE) ;
	{
		glMatrixMode(GL_TEXTURE) ;
		glLoadIdentity() ;
		glScalef(0.5, 0.5, 1.0) ;
		glTranslatef(1.0, 1.0, 0.0) ;
	}
//	glPopAttrib() ;
	glMatrixMode(GL_MODELVIEW) ;
}

void ClearTextureMatrix()
{
//	glPushAttrib(GL_MATRIX_MODE) ;
	{
		glMatrixMode(GL_TEXTURE) ;
		glLoadIdentity() ;
	}
//	glPopAttrib() ;
	glMatrixMode(GL_MODELVIEW) ;
}


// ޥåԥ
// Ķޥåԥ󥰥ѥ
// TEXTURE0 ˥ޥåפ򥻥å
// ȥ顼ʥǥե塼ˤ diffuse * 2.0 - 1.0 򥻥å
// ֥ɤ褹뤬ХåեΦץ졼ˤϥե饰ȤΦͤ񤭹ߤᣲѥɬ
// ѥܤǾ֥ɤ
// ѥܤϥ֥ɤʤǦͤΤ glColorMask(GL_FALSE, GL_FALSE, GL_FALSE, GL_TRUE)
// Υ饤ȲûϦͤ꡼ɥ꡼ glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_FALSE) ˤ
// ֥ɴؿ glBlendFunc(GL_DST_ALPHA, GL_ONE) 
void SetGlossMappingTextureEnvMode()
{
	glActiveTexture(activeTexExplicit + GL_TEXTURE0) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_COMBINE) ;

	// RGB function = Modulate (PC * TC)
	glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_RGB, GL_MODULATE) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE0_RGB, GL_PREVIOUS) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND0_RGB, GL_SRC_COLOR) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE1_RGB, GL_TEXTURE) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND1_RGB, GL_SRC_COLOR) ;

	// Alpha function = Add Signed
	glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_ALPHA, GL_ADD_SIGNED) ;

	// Arg0: SA
	glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE1_ALPHA, GL_PRIMARY_COLOR) ; // GL_PREVIOUS) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND1_ALPHA, GL_SRC_ALPHA) ;
	// Arg1: TA
	glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE0_ALPHA, GL_TEXTURE) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND0_ALPHA, GL_SRC_ALPHA) ;

}

void SetShwdowMappingTextureEnvMode()
{
	glActiveTexture(activeTexExplicit + GL_TEXTURE0) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_COMBINE) ;

	glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_RGB, GL_MODULATE) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE0_RGB, GL_PREVIOUS) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND0_RGB, GL_SRC_COLOR) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE1_RGB, GL_TEXTURE) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND1_RGB, GL_SRC_COLOR) ;

	glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_ALPHA, GL_REPLACE) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE0_ALPHA, GL_PREVIOUS) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND0_ALPHA, GL_SRC_ALPHA) ;

	glActiveTexture(activeTexGenerate + GL_TEXTURE0) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_COMBINE) ;

	glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_RGB, GL_MODULATE) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE0_RGB, GL_PREVIOUS) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND0_RGB, GL_SRC_COLOR) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE1_RGB, GL_TEXTURE) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND1_RGB, GL_SRC_COLOR) ;

	glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_ALPHA, GL_ADD_SIGNED) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE0_ALPHA, GL_PRIMARY_COLOR) ;	// GL_PREVIOUS
	glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND0_ALPHA, GL_SRC_ALPHA) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE1_ALPHA, GL_TEXTURE) ;
	glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND1_ALPHA, GL_ONE_MINUS_SRC_ALPHA) ;
}

void SetProjectionTextureEnvMode(int shadow)
{
	if (shadow)
	{
		glCallList(SHADOW_MAP_TEX_ENV_MODE_LIST) ;
	}
	else
	{
		glActiveTexture(activeTexGenerate + GL_TEXTURE0) ;
		glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE) ;
	}
}

void EnableProjectionTexture()
{
	SetTextureProjectionMatrix() ;

	glEnable(GL_TEXTURE_2D) ;
	glEnable(GL_TEXTURE_GEN_S) ;
	glEnable(GL_TEXTURE_GEN_T) ;

	if (spotLight)
		glEnable(GL_TEXTURE_GEN_Q) ;
	else
		glDisable(GL_TEXTURE_GEN_Q) ;
}


void EnableSolidTexture()
{
	ClearTextureMatrix() ;
	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE) ;
	glEnable(GL_TEXTURE_2D) ;
}


// ߥХɤƤƥΥե륿
void SetTextureFilter(GLint filter)
{
	GLint gl_mag_filter, gl_min_filter ;

	switch (filter) {
	case GL_NEAREST:
		gl_mag_filter = gl_min_filter = GL_NEAREST ;
		break ;

	case GL_LINEAR:
		gl_mag_filter = gl_min_filter = GL_LINEAR ;
		break ;

	case GL_NEAREST_MIPMAP_NEAREST:
		gl_mag_filter = GL_NEAREST ;
		gl_min_filter = GL_NEAREST_MIPMAP_NEAREST ;
		break ;

	case GL_LINEAR_MIPMAP_NEAREST:
		gl_mag_filter = GL_LINEAR ;
		gl_min_filter = GL_LINEAR_MIPMAP_NEAREST ;
		break ;

	case GL_NEAREST_MIPMAP_LINEAR:
		gl_mag_filter = GL_NEAREST ;
		gl_min_filter = GL_NEAREST_MIPMAP_LINEAR ;
		break ;

	case GL_LINEAR_MIPMAP_LINEAR:
		gl_mag_filter = GL_LINEAR ;
		gl_min_filter = GL_LINEAR_MIPMAP_LINEAR ;
		break ;

	default:
		gl_mag_filter = gl_min_filter = 0;
		break;
	}

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, gl_mag_filter) ;
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, gl_min_filter) ;
}


// ߥХɤƤƥκ
void SetTextureMaxAnisotropy(GLfloat anisotropy)
{
	if (has_texture_filter_anisotropic)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAX_ANISOTROPY, anisotropy) ;
}


// ƥκ򥻥å
void SetAllTexturesMaxAnisotropy(GLfloat anisotropy)
{
	for (int i = 0 ; i < MAX_LIGHTS ; i ++) {
		glBindTexture(GL_TEXTURE_2D, SPOT_TEXTURE[i]) ;
		SetTextureMaxAnisotropy(anisotropy) ;
	}

	glBindTexture(GL_TEXTURE_2D, FLOOR_TEXTURE) ;
	SetTextureMaxAnisotropy(anisotropy) ;

	glBindTexture(GL_TEXTURE_2D, FLOOR_WITH_GLOSS_TEXTURE) ;
	SetTextureMaxAnisotropy(anisotropy) ;

	glBindTexture(GL_TEXTURE_2D, HELP_TEXTURE) ;
	SetTextureMaxAnisotropy(anisotropy) ;
}


void LoadTextureImage(TRUEIMAGE **image, const String& name)
{
	String	effectivePath ;
	*image = LoadTextureImage(name, 0, NULL, &effectivePath) ;

	if (!(*image)) {
		cerr << "Can't open file \"" << name << "\" in path." << endl ;

#ifdef WIN32
		MessageBox(NULL, _T(String("Can't open file \"") + name + "\" in path."), _T("Loading Image Error"), MB_OK | MB_ICONSTOP) ;
#endif
		ExitProcedure(FAILURE) ;
	} else {
		cout << "Loading ... \"" << effectivePath << "\"." << endl ;
	}
}


// image ƥ˥å
void SetTextureImage(TRUEIMAGE *image, String internalFormat, int arrayComponents)
{
	GLenum tformat = InternalFormat(internalFormat) ;

	{
		GLint err ;

		err = Build2DMipmaps(image, tformat, arrayComponents);
		if (err) {
			cerr << "GLU Error: " << (char *)gluErrorString((GLenum)err) << endl ;

#ifdef WIN32
			MessageBox(NULL, _T((char *)gluErrorString((GLenum)err)), _T("GLU Error"), MB_OK | MB_ICONSTOP) ;
#endif
			ExitProcedure(FAILURE) ;
		}
	}
}


STATUS GLUTInitialize(Option& option)
{
	int argc = option.ArgC() ;

	glutInit(&argc, option.ArgV()) ;
	glutInitDisplayMode(glutBuff | GLUT_RGB | GLUT_DEPTH | GLUT_ALPHA) ;	//  | GLUT_STENCIL) ;

	glutInitWindowSize(width, height) ;

	title = option.GetString("-title", TITLE, 2) ;
	winIDglut = glutCreateWindow(title) ;

	return SUCCESS ;
}

// glut ХåϿ
void SetGLUTCallback()
{
	glutReshapeFunc(ReshapeWindow) ;
	glutKeyboardFunc(HandleKey);
	glutDisplayFunc(ObjectProc) ;
	glutMouseFunc(MouseProc) ;
//	glutSpecialFunc(SpecialKeyProc) ;
	glutMotionFunc(MouseMotion) ;
	glutIdleFunc(Redisplay) ;
	glutTimerFunc(CALC_FPS_INTERVAL, FramesPerSecond, 0) ;
}

// Хåؿ
// ɥΥե졼󥤥٥ȥϥɥ
void ReshapeWindow(int x, int y)
{
	glViewport(0,0, x,y) ;

	// ɥνĲˤäѲʤʤġ̵̡
	static GLdouble sn30 = Sin(50.0*0.5) ;

	if (x <= y) {
		fov         = 25.0 * 2.0 ;
	} else {
		GLdouble sn = sn30 * (GLdouble)y / x, cs ;
		cs          = 1.0 - sn * sn ;
		fov         = 25.0 + ATan2(sn, cs) ;
	}
	aspectRatio = (GLdouble)x / y ;


//	glGetFloatv(GL_PROJECTION_MATRIX, projection) ;
	glMatrixMode(GL_MODELVIEW) ;

	// Save Now Window size for Mouse evnet
	width  = x ;
	height = y ;

	// FPS ַ׻
	fps_position.X() = -0.9 ;
	fps_position.Y() = 1.0 - (1.0 / width * 15.0) - 0.1 ;
	fps_position.Z() = 0.0 ;

	// ľ FPS Ʒ׻
	glutTimerFunc(SWITCH_FPS_INTERVAL, FramesPerSecond, 1) ;

	// ƥ㥵Ŭѹ
	InitializeShadowTextures() ;
}

// ܡɥ٥ȥϥɥ
void HandleKey(unsigned char key, int x, int y)
{
    switch (key)
	{
	case 0x1b:	// ESC ǽλ
		ExitProcedure() ;
		break ;

	case 'o':	// 'o' 'O'  FPS ON/OFF
	case 'O':
		if (!outputFPS)
		{
			outputFPS = TRUE ;
			UpdateStatusList() ;
		}
		else
		{
            outputFPS = FALSE ;
		}
		break ;

	case 'e':	// 'e' 'E'  View ѹ
		{
			viewPoint ++ ;
			if (viewPoint >= nLights)
				viewPoint = -1 ;

			if (viewPoint < 0)
				SetTemporaryWindowTitle("Eye View.") ;
			else
				SetTemporaryWindowTitle("Light " + NumToString(viewPoint) + " View.") ;
		}
		UpdateStatusList() ;
		break ;

	case 'E':
		{
			viewPoint -- ;
			if (viewPoint < -1) viewPoint = nLights -1 ;

			if (viewPoint < 0)
				SetTemporaryWindowTitle("Eye View.") ;
			else
				SetTemporaryWindowTitle("Light " + NumToString(viewPoint) + " View.") ;
		}
		UpdateStatusList() ;
		break ;

	case 'v':
	case 'V':	// 'v' 'V' ǥܥ塼饤 ON/OFF
		{
			if (volumeLight)
			{
				volumeLight = FALSE ;
				SetTemporaryWindowTitle("Disable Atmospheric Effect.") ;
			}
			else
			{
				volumeLight = TRUE ;
				SetTemporaryWindowTitle("Enable Atmospheric Effect.") ;
			}
		}
		UpdateStatusList() ;
		break ;

	case 'r':
	case 'R':	// 'r' 'R' ǾؤαǤꤳ ON/OFF
		{
			if (reflection)
			{
				reflection = FALSE ;
				SetTemporaryWindowTitle("Disable Reflection.") ;
			}
			else
			{
				reflection = TRUE ;
				SetTemporaryWindowTitle("Enable Reflection.") ;
			}
		}
		UpdateStatusList() ;
		break ;

	case 'd':
	case 'D':	// 'd' 'D' ǥޥ ON/OFF
		{
			if (depthMask)
			{
				depthMask = FALSE ;
				SetTemporaryWindowTitle("Disable Masking Reflection.") ;
			}
			else
			{
				depthMask = TRUE ;
				SetTemporaryWindowTitle("Enable Masking Reflection.") ;
			}
		}
		UpdateStatusList() ;
		break ;

	case 'f':
	case 'F':	// 'f' 'F' ǾؤαǤꤳߤΥեͥ ON/OFF
		{

			if (fresnel)
			{
				fresnel = FALSE ;
				SetTemporaryWindowTitle("Disable Fresnel Effect.") ;
			}
			else
			{
				fresnel = TRUE ;
				SetTemporaryWindowTitle("Enable Fresnel Effect.") ;
			}

/*
			if (perVertexFresnel)
				perVertexFresnel = FALSE ;
			else
				perVertexFresnel = TRUE ;
*/
		}
		UpdateStatusList() ;
		break ;

	case 's':
	case 'S':	// 's' 'S' ǲǽʤ Shadow Map ON/OFF
		if (canShadow)
		{
			if (shadow)
			{
				shadow = FALSE ;
				SetTemporaryWindowTitle("Disable Shadow Mapping.") ;
			}
			else
			{
				shadow = TRUE ;
				SetTemporaryWindowTitle("Enable Shadow Mapping.") ;
			}

			InitializeShadowTextures() ;
		}
		else
		{
			SetTemporaryWindowTitle("Can't Enable Shadow Mapping.") ;
		}
		UpdateStatusList() ;
		break ;

	case 'g':
	case 'G':	// 'g' 'G' ǲǽʤ Gloss Map ON/OFF
		if (canGloss)
		{
			if (gloss)
			{
				gloss = FALSE ;
				SetTemporaryWindowTitle("Disable Gloss Mapping.") ;
			}
			else
			{
				gloss = TRUE ;
				SetTemporaryWindowTitle("Enable Gloss Mapping.") ;
			}
		}
		else
		{
			SetTemporaryWindowTitle("Can't Enable Gloss Mapping.") ;
		}
		UpdateStatusList() ;
		break ;

	case 'l':
	case 'L':	// 'l' 'L' ʿԸݥåȥ饤ѹ
		{
			if (spotLight)
			{
				spotLight = FALSE ;
				SetTemporaryWindowTitle("Parallel Light Source.") ;
			}
			else
			{
				spotLight = TRUE ;
				SetTemporaryWindowTitle("Spot Light Source.") ;
			}

			InitializeLights() ;
			InitializeProjectionPlanes() ;
		}
		UpdateStatusList() ;
		break ;

	case 'p':
	case 'P':	// 'p' 'P' ǥݡ
		{
			if (pause_f)
			{
				pause_f = FALSE ;
			}
			else
			{
				pause_f = TRUE ;
				SetTemporaryWindowTitle("Pause!!") ;
			}

			reconstShadowMapFlag = TRUE ;
		}
		break ;

	case ' ':	// Space ǥ󥰥륹ƥå
//		if (pause_f)
		{
			pause_f = TRUE ;
			MoveObjects(TRUE) ;
//			SetTemporaryWindowTitle("Step!!") ;
		}
		break ;

	case 'h':
	case 'H':	// 'h' 'H' ǥإɽ
		{
			if (tHelpIntensity > 0.0)
				tHelpIntensity = 0.0 ;
			else
				tHelpIntensity = 1.0 ;
		}
		break ;

	case 't':
	case 'T':	// 't' 'T' ǥɥƥΥե륿ѹ
		{
			if (shadowTexFilter == GL_NEAREST)
			{
				shadowTexFilter = GL_LINEAR ;
				SetTemporaryWindowTitle("Shadow Map Filter: Bi-linear") ;
			}
			else
			{
				shadowTexFilter = GL_NEAREST ;
				SetTemporaryWindowTitle("Shadow Map Filter: Nearest Point") ;
			}

			InitializeShadowTextures() ;
		}
		break ;

	case 'u':
	case 'U':	// 'u' 'U' ǥƥΰե륿ѹ
		if (has_texture_filter_anisotropic) {
			if (key == 'u') {
				currentAnisotropy *= 2.0 ;
				if (currentAnisotropy > maxAnisotropy)
					currentAnisotropy = 1.0 ;
			} else { // if (key == 'U')
				currentAnisotropy *= 0.5 ;
				if (currentAnisotropy < 1.0)
					currentAnisotropy = maxAnisotropy ;
			}

			SetAllTexturesMaxAnisotropy(currentAnisotropy) ;

			if (currentAnisotropy == 1.0)
				SetTemporaryWindowTitle("Disable Anisotropic Filtering (Max Anisotropy: 1).") ;
			else
				SetTemporaryWindowTitle(String("Enable Anisotropic Filtering (Max Anisotropy: ") + NumToString(currentAnisotropy) + ").") ;
		}
		else
			SetTemporaryWindowTitle("Can't Enable Enable Anisotropic Filtering. (Max Anisotropy: 1).") ;
		break ;

	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	// '0'  '4' ǥ饤ȿѹ
		{
			EnableDiffuse(-1) ;
			nLights = (int)(key - '0') ;
			InitializeLights() ;

			if (nLights)
				SetTemporaryWindowTitle(NumToString(nLights) + " Light Source(s).") ;
			else
				SetTemporaryWindowTitle("Ambient Only.") ;
		}
		UpdateStatusList() ;
		break ;

	case '5':
	case '6':
	case '7':
	case '8': // '5'  '8' ǥ֥ȿ 1  4
		{
			nObjects = (int)(key - '0') - 4 ;
			InitializeLights() ;
		}
		UpdateStatusList() ;
		break ;

	case 'a':	// 'a' ǦХ󥯥
		{
			alphaBias += 0.5 ;
			SetAlphaBias() ;

			String t ;
			t.Format("Alpha Bias: %3.1f", alphaBias) ;
			SetTemporaryWindowTitle(t) ;
		}
		break ;

	case 'A':	// 'A' ǦХǥ
		{
			alphaBias -= 0.5 ;
			SetAlphaBias() ;

			String t ;
			t.Format("Alpha Bias: %3.1f", alphaBias) ;
			SetTemporaryWindowTitle(t) ;
		}
		break ;
	}
}


void InitializeProjectionPlanes()
{
	s_plane[0] = 1.0 ;	s_plane[1] = 0.0 ;	s_plane[2] = 0.0 ;	s_plane[3] = 0.0 ;
	t_plane[0] = 0.0 ;	t_plane[1] = 1.0 ;	t_plane[2] = 0.0 ;	t_plane[3] = 0.0 ;
	q_plane[0] = 0.0 ;	q_plane[1] = 0.0 ;	q_plane[2] = 1.0 ;	q_plane[3] = 0.0 ;

	glActiveTexture(activeTexGenerate + GL_TEXTURE0) ;
	glTexGenfv(GL_S, GL_EYE_PLANE, s_plane) ;
	glTexGenfv(GL_T, GL_EYE_PLANE, t_plane) ;
	glTexGenfv(GL_Q, GL_EYE_PLANE, q_plane) ;
}


// shadow ˤä ƥƥΥХNo 򥻥å
void SetProjectionTextureObject(int shadow)
{
	if (canShadow && shadow)
	{
		for (int i = 0 ; i < MAX_LIGHTS ; i ++)
			PROJECT_TEXTURE[i] = SHADOW_TEXTURE[i] ;
//			PROJECT_TEXTURE[i] = SPOT_TEXTURE[i] ;
	}
	else
	{
		// ݥåȤӥɥޥåץƥ
		for (int i = 0 ; i < MAX_LIGHTS ; i ++)
			PROJECT_TEXTURE[i] = SPOT_TEXTURE[i] ;
	}
}


// ǥץ쥤٥ȥϥɥ
// ֥Ȥư
void ObjectProc()
{
	CheckOpenGLError() ;

	oTick = nTick ;
	nTick = GetErapsedTime() ;
	oldMSecStep = mSecStep ;
	mSecStep = nTick - oTick ;

	// ȥ
	ControlView() ;

	// إ׵
	helpIntensity += (tHelpIntensity - helpIntensity) * 0.3f ;
//	cout << "h: " << helpIntensity << "  tH: " << tHelpIntensity << endl ;

	// ֥Ȱư
	if (!pause_f)
		MoveObjects() ;

	// 
	Render() ;

	// ե졼५
	frameCount ++ ;
	f_cnt ++ ;
}

// 襤٥ȶȯ
// ɥХå
void Redisplay()
{
	glutPostRedisplay() ;
}

// ޥܥ󥤥٥ȥϥɥ
// ɥå ϣΡϣƣ
void MouseProc(int button, int state, int x, int y)
{
	if (button == GLUT_LEFT_BUTTON)
	{
		// ɥåϣλϥޥΥɥåΰ֤˸ߤΰ֤¸
		if (state == GLUT_DOWN)
		{
			dragL = TRUE  ;
			dragX = x ;
			dragY = y ;
		}
		else if (state == GLUT_UP)
			dragL = FALSE ;
	}
	else if (button == GLUT_RIGHT_BUTTON)
	{
		if (state == GLUT_DOWN)
		{
			dragR = TRUE ;
		}
		else if (state == GLUT_UP)
			dragR = FALSE ;
	}

	mouseX = x ;
	mouseY = y ;
}

// ޥưХå
void MouseMotion(int x, int y)
{
	mouseX = x ;
	mouseY = y ;
}


// Ūʥɥȥ륻å
// ôְŪ˥ȥ򥻥å
void SetTemporaryWindowTitle(const String& title, int wait)
{
//	if (loop_count < 10)
//		return ;

	changeTitleWait = wait ;
	glutSetWindowTitle(title) ;
}


// ɥȥ륻å
// SetTemporaryWindowTitle()
// ξ硢ְʾФäƤʤ̵
void SetWindowTitle(const String& title)
{
	if (!changeTitleWait)
		glutSetWindowTitle(title) ;
}


// ޡ٥ȥХåFPS׻
void FramesPerSecond(int value)
{
	static int  o_tick = 0, n_tick = 0 ;
	static char c_fps[32] = "____.__ FPS _____.___ kTPS" ;

	if (changeTitleWait)
		changeTitleWait -- ;

	o_tick = n_tick ;
	n_tick = (int)GetErapsedTime() ; /* XXX: ǥ㥹Ȥ? */

	// f_cnt  0ĤޤޤäƱ롼פǥ뤵줿ϡʾ׻ʤ
	if (f_cnt) {
		if (n_tick > o_tick)
			fps = f_cnt / ((float)(n_tick - o_tick) / 1000) ;

		snprintf(c_fps, 32, "%7.2f FPS", fps) ;

		str_fps = String(c_fps) ;

		f_cnt = 0 ;
	}

	SetWindowTitle(str_fps + " " + title) ;

	if (value == 1)
		glutTimerFunc(SWITCH_FPS_INTERVAL, FramesPerSecond, 2) ;
	else if (value == 0)
		glutTimerFunc(CALC_FPS_INTERVAL, FramesPerSecond, 0) ;
}


void MakeStatusString()
{
	str_status = str_fps ;
}


void UpdateStatusList(GLenum mode)
{
	if (STATUS_STRING_LIST)
		glDeleteLists(STATUS_STRING_LIST, 1) ;

	MakeStatusString() ;

	glNewList(STATUS_STRING_LIST, mode) ;
	{
		DrawStatus() ;
	}
	glEndList() ;
}


// ɥ FPSɽ
void DrawStatus()
{
	glPushAttrib(GL_ALL_ATTRIB_BITS) ;
	{
		glDisable(GL_LIGHTING) ;
		glActiveTexture(activeTexGenerate + GL_TEXTURE0) ;
		glDisable(GL_TEXTURE_2D) ;      // ƥϣƣ
		glActiveTexture(activeTexExplicit + GL_TEXTURE0) ;
		glDisable(GL_TEXTURE_2D) ;      // ƥϣƣ
		glDisable(GL_DEPTH_TEST) ;      // ǥץƥȣϣƣơɬɽ

		glPushMatrix() ;
		{
			glLoadIdentity() ;      // ǥӥ塼ñ̹

			glMatrixMode(GL_PROJECTION) ;
			glPushMatrix() ;
			{
				glLoadIdentity() ;      // ͱƹñ̹

				glColor3f(0.7, 0.7, 0.5) ;
				DrawString(str_status, fps_position.X() + 2.0 / width ,fps_position.Y(),fps_position.Z(), GLUT_BITMAP_8_BY_13) ;

				glColor3f(0.9, 0.9, 0.7) ;
				DrawString(str_status, fps_position.X(),fps_position.Y(),fps_position.Z(), GLUT_BITMAP_8_BY_13) ;
			}
			glPopMatrix() ;
			glMatrixMode(GL_MODELVIEW) ;
		}
		glPopMatrix() ;
	}
	glPopAttrib() ;
}



// ֥Ȱư
void MoveObjects(int fixSpeed)
{
	animationCount ++ ;
	reconstShadowMapFlag = TRUE ;

	float msec ;
	if (fixSpeed) {
		msec = 16.6666 ;
	} else {
		if (timeRes >= 3.0 || timeRes <= 0.0) {
			if (fps <= 0.0) {
				msec = 16.6666 ;
			} else {
				msec = 1000.0 / fps ;
			}
		} else {
			msec = mSecStep ;
		}

		if (msec > 50.0)
			msec = 50.0 ;
		else if (msec < 5.0)
			msec = 5.0 ;
	}

	MoveLights(msec) ;
	MovePolyhedron(msec) ;

	GradationBG() ;
}

void GradationBG()
{
	float ratio = (Sin(animationCount * 360.0 / 1024.0 - 90.0)) * 0.5 + 0.5 ;

	bg[0] = bg0[0] * ratio + bg1[0] * (1 - ratio) ;
	bg[1] = bg0[1] * ratio + bg1[1] * (1 - ratio) ;
	bg[2] = bg0[2] * ratio + bg1[2] * (1 - ratio) ;
	bg[3] = bg0[3] * ratio + bg1[3] * (1 - ratio) ;

	// ꥢ
	glClearColor(bg[0], bg[1], bg[2], bg[3]) ;
}

void MoveLights(float msec)
{
	glMatrixMode(GL_MODELVIEW) ;
	glPushMatrix() ;
	{
		for (int i = 0 ; i < nLights ; i ++) {
			// pitch yaw for position, local roll
			light[i].angle.Transform(msec) ;

			// distance, pitch
			light[i].angle2.Transform(msec) ;
			light[i].distance = light[i].dbase + Sin(light[i].angle2.status.X()) * 1.0 ;
			light[i].pitch = (Sin(light[i].angle2.status.Y()) - 0.75) * 12.0 ;

			light[i].position(0.0, 0.0, light[i].distance) ;
			float pospitch = (sin(Rad(light[i].angle.status.X())) + 1.5) * 30.0 ;
			float s = sin(Rad(pospitch)), c = cos(Rad(pospitch)) ;
			float wy = light[i].position.Y(), wz = light[i].position.Z() ;
			light[i].position.Y() = c * wy - s * wz ;
			light[i].position.Z() = s * wy + c * wz ;

			s = sin(Rad(light[i].angle.status.Z())) ;
			c = cos(Rad(light[i].angle.status.Z())) ;
			float wx = light[i].position.X() ;
			wz = light[i].position.Z() ;
			light[i].position.Z() = c * wz - s * wx ;
			light[i].position.X() = s * wz + c * wx ;

			{
				glPushMatrix() ;
				{
					static GLfloat lightmat[16] ;

					glLoadIdentity() ;
					glRotatef(light[i].angle.status.Y(), 0.0, 0.0, 1.0) ;
					glRotatef(light[i].pitch, 1.0, 0.0, 0.0) ;
					gluLookAt(light[i].position.X(), light[i].position.Y(), light[i].position.Z(),
							  lightCenter[i][0], lightCenter[i][1], lightCenter[i][2],  0.0, 1.0, 0.0) ;

					glGetFloatv(GL_MODELVIEW_MATRIX, lightmat) ;

					// žֹʵչ
					light[i].matrix[0] = lightmat[0] ;
					light[i].matrix[1] = lightmat[4] ;
					light[i].matrix[2] = lightmat[8] ;
					light[i].matrix[3] = 0.0 ;	// lightmat[3] ;
					light[i].matrix[4] = lightmat[1] ;
					light[i].matrix[5] = lightmat[5] ;
					light[i].matrix[6] = lightmat[9] ;
					light[i].matrix[7] = 0.0 ;	// lightmat[7] ;
					light[i].matrix[8] = lightmat[2] ;
					light[i].matrix[9] = lightmat[6] ;
					light[i].matrix[10] = lightmat[10] ;
					light[i].matrix[11] = 0.0 ;	// lightmat[11] ;

					light[i].matrix[12] = light[i].position.X() ;
					light[i].matrix[13] = light[i].position.Y() ;
					light[i].matrix[14] = light[i].position.Z() ;

					light[i].matrix[15] = 1.0 ;	// lightmat[15] ;
				}
				glPopMatrix() ;
			}
		}
	}
	glPopMatrix() ;
}

void MovePolyhedron(float msec)
{
	world.angle.Transform(msec) ;

	for (int i = 0 ; i < nObjects ; i ++) {
		object[i].angle.Transform(msec) ;
	}
}

// 
void ControlView()
{
	float x = 0.0, y = 0.0 ;

	if (dragL && (mouseX != dragX || mouseY != dragY)) {
		spinX = (mouseX - dragX) * mSpeed / width ;
		spinY = (mouseY - dragY) * mSpeed / height ;

		dragX = mouseX ;
		dragY = mouseY ;
	} else {
		spinX *= 0.9 ;
		spinY *= 0.9 ;
	}

	x = spinX ;
	y = spinY ;

	glMatrixMode(GL_MODELVIEW) ;
	glPushMatrix() ;
	{
		glLoadIdentity() ;

		if (x != 0.0 || y != 0.0) {
			static Vector3d axis ;

			axis(y, x, 0.0) ;
			axis.Unit() ;
			glRotatef(sqrt(x * x + y * y), axis.X(), axis.Y(), axis.Z()) ;
		}

		glMultMatrixf(controlObjectMatrix) ;
		glGetFloatv(GL_MODELVIEW_MATRIX, controlObjectMatrix) ;
	}
	glPopMatrix() ;


	// Υƥɥ
	if (dragR)
	{
		float fx = (float)mouseX / width ;	// 0.0  1.0
		tLightPlaneSize = Pow(4.0, fx * 2.0) / 4.0 * LIGHT_PLANE_SIZE ;

		float fy = (float)mouseY / height ;	// 0.0  1.0
		tdistance = 32.0 - fy * 32.0 ;
	}

	if (!pause_f)
		lightPlaneSize += (tLightPlaneSize - lightPlaneSize) * 0.1 ;

	distance += (tdistance - distance) * 0.1 ;
}


// 
void Render()
{
	// ɥޥåץåץǡ
	if (shadow && reconstShadowMapFlag)
	{
		UpdateShadowMaps() ;
		reconstShadowMapFlag = FALSE ;
	}

	// ĥ
	RenderScene() ;

	// إɽ
	RenderHelpMessage(helpIntensity) ;

	// ơɽ
	if (outputFPS) {
		if (f_cnt == 0) {
			UpdateStatusList(GL_COMPILE_AND_EXECUTE) ;
		} else {
			glCallList(STATUS_STRING_LIST) ;
		}
	}

	// ХåեΥåפӥ쥯ȥХåեΥեå
	if (glutBuff == GLUT_DOUBLE) {
		glutSwapBuffers() ;
	} else {
		glFlush() ;
	}
}


void UpdateShadowMaps()
{
	glPushAttrib(GL_ENABLE_BIT) ;
	{
		glDisable(GL_DITHER) ;
		glDisable(GL_LIGHTING) ;
		glEnable(GL_SCISSOR_TEST) ;

		for (int i = 0 ; i < nLights ; i ++) {
			UpdateShadowMap(i) ;
		}
	}
	glPopAttrib() ;
}

void UpdateShadowMap(int lNo)
{
	glViewport(0, 0, shadowTexWidth, shadowTexHeight) ;
	SetLightViewAndProjection(lNo) ;

	// Хåեꥢ
	glClear(GL_DEPTH_BUFFER_BIT) ;
	RenderObjectsForShadow(lNo) ;

	// Хåեƥإԡ
	glBindTexture(GL_TEXTURE_2D, SHADOW_TEXTURE[lNo]) ;
	CopyTexSubImage2D(GL_TEXTURE_2D, 0,  0, 0,  0, 0,  shadowTexWidth, shadowTexHeight) ;
}

void RenderObjectsForShadow(int lNo)
{
	glActiveTexture(activeTexExplicit + GL_TEXTURE0) ;
	glDisable(GL_TEXTURE_2D) ;
	glActiveTexture(activeTexGenerate + GL_TEXTURE0) ;
	glDisable(GL_TEXTURE_2D) ;

	glColorMask(GL_FALSE, GL_FALSE, GL_FALSE, GL_TRUE) ;
	glDepthFunc(GL_LESS) ;
	glEnable(GL_DEPTH_TEST) ;
	glDepthMask(GL_TRUE) ;

	// Render Polyhedron
	glPushMatrix() ;
	{
		glRotatef(90.0, 1.0, 0.0, 0.0) ;
		RenderPolyhedronForShadow() ;
	}
	glPopMatrix() ;

	glActiveTexture(GL_TEXTURE0) ;
	glEnable(GL_TEXTURE_2D) ;
	glBindTexture(GL_TEXTURE_2D, SPOT_TEXTURE[lNo]) ;

	glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_FALSE) ;
	glDisable(GL_DEPTH_TEST) ;

	glCallList(SPOT_COPY_LIST) ;
}

void SetLightViewAndProjection(int lNo)
{
	glMatrixMode(GL_PROJECTION) ;
	glLoadIdentity() ;
	if (spotLight) {
		glFrustum(-lightPlaneSize,
			   lightPlaneSize,
			  -lightPlaneSize,
			   lightPlaneSize,
			  1.0, LIGHT_MAX_DISTANCE) ;
	} else {
		glOrtho(-lightPlaneSize * LIGHT_PARALLEL_SCALE,
			 lightPlaneSize * LIGHT_PARALLEL_SCALE,
			-lightPlaneSize * LIGHT_PARALLEL_SCALE,
			 lightPlaneSize * LIGHT_PARALLEL_SCALE,
			1.0, LIGHT_MAX_DISTANCE) ;
	}

	glMatrixMode(GL_MODELVIEW) ;
	glLoadIdentity() ;
	TransformLightView(lNo) ;
}

void TransformLightView(int lNo)
{
	glRotatef(light[lNo].angle.status.Y(), 0.0, 0.0, 1.0) ;
	glRotatef(light[lNo].pitch, -1.0, 0.0, 0.0) ;
	gluLookAt(light[lNo].position.X(), light[lNo].position.Y(), light[lNo].position.Z(),
			  lightCenter[lNo][0], lightCenter[lNo][1], lightCenter[lNo][2],  0.0, -1.0, 0.0) ;
}

void SetViewAndProjection(int vPoint)
{
	if (vPoint == -1)
	{
		glMatrixMode(GL_PROJECTION) ;
		glLoadIdentity() ;

		nearClip = distance - 10.0 ;
		farClip  = distance + 10.0 ;
		if (nearClip <= 0.5) nearClip = 0.5 ;
		gluPerspective(fov, aspectRatio, nearClip, farClip) ;

		// 饻å
		glMatrixMode(GL_MODELVIEW) ;
		glLoadIdentity() ;
		gluLookAt(0.0,0.0,0.0, 0.0,0.0,-1.0, 0.0,1.0,0.0) ;

		// ȥ
		glTranslatef(0.0, 0.0, -distance) ;
		glMultMatrixf(controlObjectMatrix) ;
	}
	else	// Light view
	{
		SetLightViewAndProjection(vPoint) ;
	}
}


// ĥ
void RenderScene()
{
	glViewport(0,0, width,height) ;
	SetViewAndProjection(viewPoint) ;

	// View 󤫤龲Υӥӥƥ׻
	if (reflection)
	{
		// 롼׸塢center  visibility åȤƤ
		int start ;
		if (perVertexFresnel)
			start = 0 ;
		else
			start = 4 ;

		for (int i = start ; i < 5 ; i ++)
		{
			GLfloat vmatrix[16] ;

			glPushMatrix() ;
			{
				glRotatef(90.0, 1.0, 0.0, 0.0) ;
				glGetFloatv(GL_MODELVIEW_MATRIX, vmatrix) ;
			}
			glPopMatrix() ;

			Vector3d origin(groundVertices[i]), normal(groundVertices[i] + Vector3d(0.0, 0.0, 1.0)), vdir ;
			normal.Transform(vmatrix) ;
			origin.Transform(vmatrix) ;

			normal = normal - origin ;
			vdir = -Unit(origin) ;
			visibility = vdir.X() * normal.X() + vdir.Y() * normal.Y() + vdir.Z() * normal.Z() ;
			if (visibility < 0.0)
				visibility = 0.0 ;

			// ĺȿͤ׻ϡβĻåȿͷ
			if (!perVertexFresnel || (i < 4 && perVertexFresnel))
			{
				if (fresnel)
					reflectRatio[i] = FresnelTermByCos(visibility, REFRACTION_RATE) ;
//					reflectRatio[i] = ReflectAlphaByCos(visibility, 0.2f, 4.0) ;
				else
					reflectRatio[i] = 0.25 ;
			}
		}
	}
	else
		visibility = 0.0 ;

	RenderObjectsWithReflection() ;
}


// Хå顼ȾƩɤĤ֤
void DrawBackgroundColor(int n)
{
	// ǥӥ塼
	glMatrixMode(GL_MODELVIEW) ;
	glPushMatrix() ;
	glLoadIdentity() ;

	// ͱƹ
	glMatrixMode(GL_PROJECTION) ;
	glPushMatrix() ;
	glLoadIdentity() ;

	// ɤĤ֤
	glColor4f(bg[0], bg[1], bg[2], 1.0 / n) ;
//	glRectf(-1.0, -1.0, 1.0, 1.0) ;
	glBegin(GL_QUADS) ;
	{
		glVertex3f(-1.0, -1.0,  0.9999) ;
		glVertex3f( 1.0, -1.0,  0.9999) ;
		glVertex3f( 1.0,  1.0,  0.9999) ;
		glVertex3f(-1.0,  1.0,  0.9999) ;
	}
	glEnd() ;

	glPopMatrix() ;
	glMatrixMode(GL_MODELVIEW) ;
	glPopMatrix() ;
}


// 
void InitializeLights()
{
	reconstShadowMapFlag = TRUE ;

	GLfloat intensity = 1.0 / (nLights + 0.5) + 0.3 ;

	for (int i = 0 ; i < MAX_LIGHTS ; i ++) {
		GLenum lightNo = (GLenum)((int)GL_LIGHT0 + i) ;

		if (spotLight) {
			SetPositionalLight(lightNo, lightpos, lightColor[i],
					   0.0,		// ambient
					   0.0,		// specular
					   intensity,	// intensity
					   1.1,         // constant attenuation
					   0.02,	// linear attenuation
					   0.0,		// quadratic attenuation
					   lightdir,	// spot direction
					   180.0) ;	// spot cutoff
		} else {  // directional light
			SetPositionalLight(lightNo, plightpos, lightColor[i],
					   0.0,		// ambient
					   0.0,		// specular
					   intensity * 0.6) ;	// intensity

			SetDirectionalLight(lightNo, plightpos, lightColor[i],
					    0.0,		// ambient
					    0.0,		// specular
					    intensity * 0.6) ;	// intensity
		}
	}
}


// 
//  GL_MODELVIEW_MATRIX Ŭڤʹ󤬥åȤƤꡢ
//  glActiveTexture(GL_TEXTUREi) Ŭڤʥƥ㤬ƥ֤ˤʤäƤɬפ
void UpdateLights()
{
	for (int i = 0 ; i < nLights ; i ++) {
		UpdateLight(i) ;
	}
}

void UpdateLight(int lNo)
{
	GLenum lightNo = (GLenum)((int)GL_LIGHT0 + lNo) ;

	glPushMatrix() ;
	{
		TransformLight(lNo) ;

		if (spotLight) {
			glLightfv(lightNo, GL_POSITION, lightpos) ;
			glLightfv(lightNo, GL_SPOT_DIRECTION, lightdir) ;

			q_plane[2] = lightPlaneSize ;
			glTexGenfv(GL_S, GL_EYE_PLANE, s_plane) ;
			glTexGenfv(GL_T, GL_EYE_PLANE, t_plane) ;
			glTexGenfv(GL_Q, GL_EYE_PLANE, q_plane) ;
		} else {
			glLightfv(lightNo, GL_POSITION, plightpos) ;

			s_plane[0] = t_plane[1] = -1.0 / (lightPlaneSize * LIGHT_PARALLEL_SCALE) ;
			glTexGenfv(GL_S, GL_EYE_PLANE, s_plane) ;
			glTexGenfv(GL_T, GL_EYE_PLANE, t_plane) ;
//			glTexGenfv(GL_Q, GL_EYE_PLANE, q_plane) ;
		}
	}
	glPopMatrix() ;
}


GLsizei AdjustTextureSizeRoundUp(int size)
{
	GLsizei	texSize ;
	double	d ;
	int		n ;
	d = Log(2, size) ;
	if ((int)d != d)
		n = (int)(d + 1.0) ;
	else
		n = (int)d ;

	texSize = Pow(2, n) ;

	if (texSize > maxTextureSize)
		texSize = maxTextureSize ;

	return texSize ;
}


GLsizei AdjustTextureSizeRoundDown(int size)
{
	GLsizei	texSize ;
	double	d ;
	int		n ;
	d = Log(2, size) ;
	n = (int)d ;

	texSize = Pow(2, n) ;

	if (texSize > maxTextureSize)
		texSize = maxTextureSize ;

	return texSize ;
}


// ɥޥåѥƥ򿷵
void InitializeShadowTextures()
{
	for (int i = 0 ; i < MAX_LIGHTS ; i ++)
	{
		if (SHADOW_TEXTURE[i] >= 1)
			glDeleteTextures(1, &SHADOW_TEXTURE[i]) ;
	}

	if (shadow)
	{
		reconstShadowMapFlag = TRUE ;

		shadowTexWidth = AdjustTextureSizeRoundDown(width) ;
		shadowTexHeight = AdjustTextureSizeRoundDown(height) ;

		glScissor(0, 0, shadowTexWidth, shadowTexHeight) ;

		// եޥå
		GLint internalFormat ;
		if      (alphaBits <= 4)	internalFormat = GL_RGBA4 ;
		if      (alphaBits <= 8)	internalFormat = GL_RGBA8 ;
		else if (alphaBits <= 12)	internalFormat = GL_RGBA12 ;
		else						internalFormat = GL_RGBA16 ;

		for (int i = 0 ; i < MAX_LIGHTS ; i ++)
		{
			glBindTexture(GL_TEXTURE_2D, AllocATexture(SHADOW_TEXTURE[i])) ;
			glTexImage2D(GL_TEXTURE_2D, 0, internalFormat, shadowTexWidth, shadowTexHeight, 0,
				     GL_RGB, GL_UNSIGNED_BYTE, NULL) ;	// GL_RGB ʹߤΰʣġˤϥߡ

//			SetupTexture2D("", GL_REPEAT, shadowTexFilter) ;
			SetupTexture2D("", GL_CLAMP, shadowTexFilter) ;
		}
	}

	SetProjectionTextureObject(shadow) ;
	SetProjectionTextureEnvMode(shadow) ;
}

// ɥ֥ȥޥȥꥯ軻
void TransformWorld()
{
	glRotatef(8.0, 0.0, 1.0, 0.0) ;
	glRotatef(world.angle.status.Z(), 0.0, 0.0, 1.0) ;
	glRotatef(8.0, 0.0, 1.0, 0.0) ;
}

void EnableAmbient()
{
	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, ambient) ;

	for (int i = 0 ; i < nLights ; i ++) {
		GLenum lightNo = (GLenum)((int)GL_LIGHT0 + i) ;
		glDisable(lightNo) ;
	}
}

void EnableDiffuse(int lNo)
{
	for (int i = 0 ; i < nLights ; i ++) {
		if (i == lNo) continue ;

		GLenum lightNo = (GLenum)((int)GL_LIGHT0 + i) ;
		glDisable(lightNo) ;
	}

	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, nambient) ;

	if (lNo >= 0) {
		GLenum lightNo = (GLenum)((int)GL_LIGHT0 + lNo) ;
		glEnable(lightNo) ;
		UpdateLight(lNo) ;
	}
}


void RenderObjectsWithReflection()
{
	if (reflection) {
		if (depthMask) {
			glClearDepth(0.0) ;
		} else {
			glClearDepth(1.0) ;
		}

		glDepthMask(GL_TRUE) ;
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT) ;
		glDepthRange(1.0, 1.0) ;
		glEnable(GL_DEPTH_TEST) ;
		glDepthFunc(GL_ALWAYS) ;
		glColorMask(GL_FALSE, GL_FALSE, GL_FALSE, GL_FALSE) ;

		glActiveTexture(activeTexGenerate + GL_TEXTURE0) ;
		glDisable(GL_TEXTURE_2D) ;
		glActiveTexture(activeTexExplicit + GL_TEXTURE0) ;
		glDisable(GL_TEXTURE_2D) ;
		glDisable(GL_LIGHTING) ;

		glCallList(TV_GROUND_LIST) ;

		glDepthRange(0.0, 1.0) ;
		glDepthFunc(GL_LESS) ;
		glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE) ;

		glPushMatrix() ;
		{
			// ؤαǤꤳȿž
			glCallList(REFLECT_TRANSFORM_LIST) ;

			glFrontFace(GL_CW) ;
			RenderObjects(TRUE) ;
			glFrontFace(GL_CCW) ;
		}
		glPopMatrix() ;

		if (stencilBits) {
			; // do nothing
		} else {
			glClearDepth(1.0) ;
			glClear(GL_DEPTH_BUFFER_BIT) ;
		}

		RenderObjects() ;
	} else {	// !reflection
		// Хåեꥢ
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT) ;
		RenderObjects() ;
	}
}


void RenderObjects(int reflectMode)
{
	activeRenderingLight = -1 ;

	glActiveTexture(activeTexGenerate + GL_TEXTURE0) ;
	glDisable(GL_TEXTURE_2D) ;
	glActiveTexture(activeTexExplicit + GL_TEXTURE0) ;
	glBindTexture(GL_TEXTURE_2D, OBJECT_TEXTURE) ;
	EnableSolidTexture() ;

	EnableAmbient() ;
	glEnable(GL_DEPTH_TEST) ;
	glDepthFunc(GL_LESS) ;
	glDepthMask(GL_TRUE) ;
	glEnable(GL_LIGHTING) ;

	glDisable(GL_BLEND) ;

	// Render Polyhedron
	glPushMatrix() ;
	{
		glRotatef(90.0, 1.0, 0.0, 0.0) ;
		RenderPolyhedron(reflectMode) ;
	}
	glPopMatrix() ;

#ifdef DISABLE_RENDER_PARALLEL_LIGHT
	// Render Light Objects
	if (spotLight)
		RenderLightObjectsAmbientPass() ;

#else	// #ifndef DISABLE_RENDER_PARALLEL_LIGHT
	RenderLightObjectsAmbientPass() ;

#endif	// #ifndef DISABLE_RENDER_PARALLEL_LIGHT ... #else

	// for TNT
	if (isTNT)
		glEnable(GL_POLYGON_OFFSET_FILL) ;

	// If shadow, Enable Alpha Test
	if (shadow)
		glEnable(GL_ALPHA_TEST) ;
	else
		glDisable(GL_ALPHA_TEST) ;

	for (int i = 0 ; i < nLights ; i ++)
	{
		activeRenderingLight = i ;

		if (i == 0)
		{
			glDepthMask(GL_FALSE) ;
			glDepthFunc(GL_LEQUAL) ;
			glBlendFunc(GL_ONE, GL_ONE) ;
			glEnable(GL_BLEND) ;
		}

		{
			glActiveTexture(activeTexGenerate + GL_TEXTURE0) ;
			glBindTexture(GL_TEXTURE_2D, PROJECT_TEXTURE[i]) ;
			EnableProjectionTexture() ;
		}

//		glActiveTexture(activeTexGenerate + GL_TEXTURE0) ;
		EnableDiffuse(i) ;

		glActiveTexture(activeTexExplicit + GL_TEXTURE0) ;

#ifdef DISABLE_LIGHT_VIEW_SHADOW
		if (shadow && i == viewPoint)
			glDisable(GL_ALPHA_TEST) ;
#endif	// #ifdef DISABLE_LIGHT_VIEW_SHADOW

		// Render Polyhedron
		glPushMatrix() ;
		{
			glRotatef(90.0, 1.0, 0.0, 0.0) ;
			RenderPolyhedron(reflectMode) ;
		}
		glPopMatrix() ;


#ifdef DISABLE_LIGHT_VIEW_SHADOW
		if (shadow && i == viewPoint)
			glEnable(GL_ALPHA_TEST) ;
#endif	// #ifdef DISABLE_LIGHT_VIEW_SHADOW
	}

	activeRenderingLight = -1 ;

	// If shadow, Disable Alpha Test
	if (shadow)
		glDisable(GL_ALPHA_TEST) ;

	// for TNT
	if (isTNT)
		glDisable(GL_POLYGON_OFFSET_FILL) ;

	// ܥ塼饤
#ifdef DISABLE_RENDER_PARALLEL_LIGHT
	if (volumeLight && spotLight)
#else	// #ifndef DISABLE_RENDER_PARALLEL_LIGHT
	if (volumeLight)
#endif	// #ifndef DISABLE_RENDER_PARALLEL_LIGHT ... #else
	{
		glEnable(GL_BLEND) ;
		glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_COLOR) ;
		glDepthMask(GL_FALSE) ;
		glDepthFunc(GL_LESS) ;
		glDisable(GL_LIGHTING) ;
		glDisable(GL_CULL_FACE) ;

		glActiveTexture(activeTexExplicit + GL_TEXTURE0) ;
		glDisable(GL_TEXTURE_2D) ;

		RenderVolumeLights(reflectMode) ;

		glEnable(GL_CULL_FACE) ;
	}

	glDepthMask(GL_TRUE) ;
	glDisable(GL_BLEND) ;
}

void RenderVolumeLights(int reflectMode)
{
	glActiveTexture(activeTexGenerate + GL_TEXTURE0) ;

	for (int i = 0 ; i < nLights ; i ++)
	{
		if (viewPoint != i)
		{
			glBindTexture(GL_TEXTURE_2D, PROJECT_TEXTURE[i]) ;
			UpdateLight(i) ;
			RenderVolumeLight(i, reflectMode) ;
		}
	}
}

void RenderVolumeLight(int lNo, int reflectMode)
{
	glPushMatrix() ;
	{
		TransformLight(lNo) ;
		glScalef(lightPlaneSize, lightPlaneSize, 1.0) ;
		if (reflectMode &&depthMask)
		{
			if (spotLight)
				glCallList(R_VOLUME_LIGHT_LIST[lNo]) ;
			else
				glCallList(R_PARALLEL_VOLUME_LIGHT_LIST[lNo]) ;
		}
		else
		{
			if (spotLight)
				glCallList(VOLUME_LIGHT_LIST[lNo]) ;
			else
				glCallList(PARALLEL_VOLUME_LIGHT_LIST[lNo]) ;
		}
	}
	glPopMatrix() ;
}


void RenderLightObjectsAmbientPass()
{
	glPushAttrib(GL_ENABLE_BIT | GL_LIGHTING | GL_BLEND) ;
	{
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA) ;
		glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE) ;

		glDisable(GL_TEXTURE_2D) ;

		// ĶѥΤߥХͭ
		glEnable(GL_LIGHT7) ;

		for (int i = 0 ; i < nLights ; i ++) {
			// ӥ塼ݥȤˤ饤Ȥɬפʤ
			if (i != viewPoint) {
				glCallList(LIGHT_MATERIAL_LIST[i]) ;
				RenderLightObjectAmbientPass(i) ;
			}
		}
	}
	glPopAttrib() ;
}

void RenderLightObjects()
{
	glPushAttrib(GL_ENABLE_BIT | GL_LIGHTING) ;
	{
		glDisable(GL_TEXTURE_2D) ;

		for (int i = 0 ; i < nLights ; i ++)
		{
			// ʬȤ˸ʤûɬפʤ
			// ˡӥ塼ݥȤˤ饤Ȥɬפʤ
			if (i != activeRenderingLight && i != viewPoint)
			{
				if (activeRenderingLight < 0)
					glCallList(LIGHT_MATERIAL_LIST[i % 2]) ;

				RenderLightObject(i) ;
			}
		}
	}
	glPopAttrib() ;
}

void RenderLightObject(int lNo)
{
	glPushMatrix() ;
	{
		TransformLight(lNo) ;
		glScalef(lightPlaneSize, lightPlaneSize, 1.0) ;
		glEnable(GL_NORMALIZE) ;
		if (spotLight)
			glCallList(LIGHT_LIST) ;
		else
			glCallList(PARALLEL_LIGHT_LIST) ;
		glDisable(GL_NORMALIZE) ;
	}
	glPopMatrix() ;
}

void RenderLightObjectAmbientPass(int lNo)
{
	glPushMatrix() ;
	{
		TransformLight(lNo) ;
		glScalef(lightPlaneSize, lightPlaneSize, 1.0) ;

		glPushAttrib(GL_ENABLE_BIT | GL_CURRENT_BIT) ;
		{
			glEnable(GL_NORMALIZE) ;
			glDisable(GL_CULL_FACE) ;

			if (spotLight)
				glCallList(LIGHT_LIST) ;
			else
				glCallList(PARALLEL_LIGHT_LIST) ;

			glEnable(GL_CULL_FACE) ;

			glDisable(GL_LIGHTING) ;
			glColor3fv(lightSourceColor[lNo]) ;
			if (spotLight)
				glCallList(LIGHT_SOURCE_PLANE_LIST) ;
			else
				glCallList(PARALLEL_LIGHT_SOURCE_PLANE_LIST) ;

			glEnable(GL_TEXTURE_2D) ;
			glBindTexture(GL_TEXTURE_2D, SPOT_TEXTURE[lNo]) ;
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR) ;

			glEnable(GL_BLEND) ;

			glColor4f(1.0, 1.0, 1.0, 0.5) ;

			if (spotLight)
				glCallList(LIGHT_PLANE_LIST) ;
			else
				glCallList(PARALLEL_LIGHT_PLANE_LIST) ;

			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR) ;
		}
		glPopAttrib() ;
	}
	glPopMatrix() ;
}

void RenderLightObjectsForShadow(int lNo)
{
	for (int i = 0 ; i < nLights ; i ++)
	{
		// ʬȤΥ饤ȤαƤ褷ʤ
		if (i != lNo)
			RenderLightObjectForShadow(i) ;
	}
}

void RenderLightObjectForShadow(int lNo)
{
	glPushMatrix() ;
	{
		TransformLight(lNo) ;
		glScalef(lightPlaneSize, lightPlaneSize, 1.0) ;
		glEnable(GL_NORMALIZE) ;
		if (spotLight)
			glCallList(S_LIGHT_LIST) ;
		else
			glCallList(S_PARALLEL_LIGHT_LIST) ;
		glDisable(GL_NORMALIZE) ;
	}
	glPopMatrix() ;
}


void RenderPolyhedron(int reflectMode)
{
	// Draw Ground
	if (!reflectMode)
	{
		// ĶѥΤ΢̤
		if (activeRenderingLight < 0)
		{
			glLightModelfv(GL_LIGHT_MODEL_AMBIENT, gambient) ;
			glDisable(GL_CULL_FACE) ;
//			glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE) ;
		}

		// reflection ǸƤϡͥ˴ŤȾƩ
		// reflection ʤ visibility = 0
		if (visibility > 0.0)
		{
			GLfloat color[4][4] ;

			if (activeRenderingLight >= 0)
			{
				// ݥåȥ饤ѥ
				glBindTexture(GL_TEXTURE_2D, FLOOR_TEXTURE) ;

				if (gloss)
				{
					// ޥåԥ󥰻ϥХåեΦѤ뤿ᡢ
					// ĺñ̤濴
					// 뤵Ĵɬפϰڤʤ
					// ֥ɴؿΥåȤΤ
					glBlendFunc(GL_DST_ALPHA, GL_ONE) ;
					glCallList(GROUND_LIST) ;
					glBlendFunc(GL_ONE, GL_ONE) ;
				}
				else	// !gloss
				{
					if (perVertexFresnel)
					{
						// ĺñ̤˥եͥ׻
						for (int v = 0 ; v < 4 ; v ++)
						{
							// 뤵ǥե塼ʣȿͷˤ˥åȡʦͤϾΥǥ
							color[v][0] = color[v][1] = color[v][2] = 1.0 - reflectRatio[v] ;
							color[v][3] = groundAlphaIndex * alphaRes ;
						}
						glEnable(GL_COLOR_MATERIAL) ;
						DrawGround(FALSE, color[0], color[1], color[2], color[3]) ;
						glColor4f(1.0, 1.0, 1.0, 1.0) ;
						glDisable(GL_COLOR_MATERIAL) ;
					}
					else
					{
						// ΣΤߤΥեͥ
						// 뤵򣱡ȿͷ˥åȡʦͤϾΥǥ
						// [0] Τ߻
						color[0][0] = color[0][1] = color[0][2] = 1.0 - reflectRatio[4] ;
						color[0][3] = groundAlphaIndex * alphaRes ;
						glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, color[0]) ;
						DrawGround() ;
						color[0][0] = color[0][1] = color[0][2] = color[0][3] = 1.0 ;
						glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, color[0]) ;
					}
				}
			}
			else
			{
				// Ķѥ
				if (gloss)
				{
					glBindTexture(GL_TEXTURE_2D, FLOOR_WITH_GLOSS_TEXTURE) ;

					if (perVertexFresnel)
					{
						// ĺñ̤˥եͥ׻
						for (int v = 0 ; v < 4 ; v ++)
						{
							color[v][0] = color[v][1] = color[v][2] = 1.0 ;
							color[v][3] = 1.0 - reflectRatio[v] ;
//							color[v][3] = 1.0 - reflectRatio[v] * 2.0 ;	// diffuse * 2 - 1	// color[v][3] = (1.0 - reflectRatio[v]) * 2.0 - 1.0 ;
						}

						glPushAttrib(GL_ALL_ATTRIB_BITS) ;
						{
							glEnable(GL_COLOR_MATERIAL) ;
							glCallList(GLOSS_MAP_TEX_ENV_MODE_LIST) ;	// ƥؿå Alpha = SA * (1 - TA) + TA

							// ѥܤǾ֥ɤ
							glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA) ;
							glEnable(GL_BLEND) ;
							glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_FALSE) ;
							DrawGround(FALSE, color[0], color[1], color[2], color[3]) ;

							// ѥܤϥ֥ɤʤǦͤΤ
							glDepthFunc(GL_LEQUAL) ;
							glColorMask(GL_FALSE, GL_FALSE, GL_FALSE, GL_TRUE) ;
							glDisable(GL_BLEND) ;
							DrawGround(FALSE, color[0], color[1], color[2], color[3]) ;
						}
						glPopAttrib() ;
					}
					else
					{
						// ΣΤߤΥեͥ
						color[0][0] = color[0][1] = color[0][2] = 1.0 ;
						color[0][3] = 1.0 - reflectRatio[4] ;

						glPushAttrib(GL_ALL_ATTRIB_BITS) ;
						{
							glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, color[0]) ;
							glCallList(GLOSS_MAP_TEX_ENV_MODE_LIST) ;	// ƥؿå Alpha = SA * (1 - TA) + TA

							// ѥܤǾ֥ɤ
							glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA) ;
							glEnable(GL_BLEND) ;
							glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_FALSE) ;
							glCallList(GROUND_LIST) ;

							// ѥܤϥ֥ɤʤǦͤΤ
							glDepthFunc(GL_LEQUAL) ;
							glColorMask(GL_FALSE, GL_FALSE, GL_FALSE, GL_TRUE) ;
							glDisable(GL_BLEND) ;
							DrawGround(GROUND_LIST) ;
						}
						glPopAttrib() ;
					}

					// ʸץ졼ϥ꡼ɥ꡼
					glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_FALSE) ;
				}
				else	// !gloss
				{
					glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA) ;
					glEnable(GL_BLEND) ;

					glBindTexture(GL_TEXTURE_2D, FLOOR_TEXTURE) ;

					if (perVertexFresnel) {
						// ĺñ̤˥եͥ׻
						for (int v = 0 ; v < 4 ; v ++) {
							color[v][0] = color[v][1] = color[v][2] = 1.0 ;
							color[v][3] = 1.0 - reflectRatio[v] ;
						}
						glEnable(GL_COLOR_MATERIAL) ;
						DrawGround(FALSE, color[0], color[1], color[2], color[3]) ;
						glColor4f(1.0, 1.0, 1.0, 1.0) ;
						glDisable(GL_COLOR_MATERIAL) ;
					} else {
						// ΣΤߤΥեͥ
						color[0][0] = color[0][1] = color[0][2] = 1.0 ;
						color[0][3] = 1.0 - reflectRatio[4] ;
						glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, color[0]) ;
						DrawGround(FALSE) ;
						color[0][3] = 1.0 ;
						glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, color[0]) ;
					}

					glBlendFunc(GL_ONE, GL_ONE) ;
					glDisable(GL_BLEND) ;
				}
			}
		} else {  // if (visibility <= 0.0)
			// ȿͤʤ
			glBindTexture(GL_TEXTURE_2D, FLOOR_TEXTURE) ;
			glCallList(GROUND_LIST) ;
		}

		if (activeRenderingLight < 0) {
			glEnable(GL_CULL_FACE) ;
			glLightModelfv(GL_LIGHT_MODEL_AMBIENT, ambient) ;
		}
	}

	glBindTexture(GL_TEXTURE_2D, OBJECT_TEXTURE) ;

	// Rotate base
	TransformWorld() ;

	// Draw polyhedron
	for (int i = 0 ; i < nObjects ; i ++) {
		RenderLocalPolyhedron(i) ;
	}
}


void RenderPolyhedronForShadow()
{
	// Draw Ground
	glDisable(GL_CULL_FACE) ;
	glCallList(S_GROUND_LIST) ;
	glEnable(GL_CULL_FACE) ;

	// Rotate base
	TransformWorld() ;

	// Draw polyhedron
	for (int i = 0 ; i < nObjects ; i ++)
	{
		RenderLocalPolyhedronForShadow(i) ;
	}
}


void RenderLocalPolyhedron(int obj)
{
	glPushMatrix() ;
	{
		TransformLocal(obj) ;
		glCallList(OBJECT_LIST[obj]) ;
	}
	glPopMatrix() ;
}


void RenderLocalPolyhedronForShadow(int obj)
{
	glPushMatrix() ;
	{
		TransformLocal(obj) ;
		glCallList(S_OBJECT_LIST[obj]) ;
	}
	glPopMatrix() ;
}

// 륪֥ȥޥȥꥯ軻
void TransformLocal(int obj)
{
	if (obj && nObjects > 1)
	{
		glRotatef((float)obj * 360.0 / (nObjects - 1),  0.0, 0.0, 1.0) ;
		glTranslatef(3.0, 0.0, 0.0) ;
	}

	switch (obj % 2)
	{
	case 0:
		glRotatef(object[obj].angle.status.X(), 1.0, 0.0, 0.0) ;
		glRotatef(object[obj].angle.status.Y(), 0.0, 1.0, 0.0) ;
		glRotatef(object[obj].angle.status.Z(), 0.0, 0.0, 1.0) ;
		break ;
	case 1:
		glRotatef(object[obj].angle.status.Y(), 0.0, 1.0, 0.0) ;
		glRotatef(object[obj].angle.status.Z(), 0.0, 0.0, 1.0) ;
		glRotatef(object[obj].angle.status.X(), 1.0, 0.0, 0.0) ;
		break ;
	case 2:
		glRotatef(object[obj].angle.status.Z(), 0.0, 0.0, 1.0) ;
		glRotatef(object[obj].angle.status.X(), 1.0, 0.0, 0.0) ;
		glRotatef(object[obj].angle.status.Y(), 0.0, 1.0, 0.0) ;
		break ;
	}
}

// 饤ȥ֥ȥޥȥꥯ軻
void TransformLight(int lNo)
{
	glMultMatrixf(light[lNo].matrix) ;
}


// λ
void ExitProcedure(STATUS state)
{
#ifdef WIN32
	if (resultTimeBeginPeriod == TIMERR_NOERROR)
		timeEndPeriod(TIMER_PERIOD) ;
#endif

	if (winIDglut)
		glutDestroyWindow(winIDglut) ;

	if (state == SUCCESS)
		exit(EXIT_SUCCESS) ;
	else
		exit(EXIT_FAILURE) ;
}


// ǥץ쥤ꥹȤӥƥ͡
GLuint AllocAList(GLuint& list)
{
	if (!(list = glGenLists(1)))
	{
		cerr << "Can't allocate Display Lists." << endl ;

#ifdef WIN32
		MessageBox(NULL, _T("Can't allocate Display Lists"), _T("Indexed Shadow Mapping Error"), MB_OK | MB_ICONSTOP) ;
#endif
		ExitProcedure(FAILURE) ;
	}
	return list ;
}

GLuint AllocATexture(GLuint& list)
{
	glGenTextures(1, &list) ;
	return list ;
}


void CheckOpenGLError()
{
	GLenum errCode = glGetError() ;

	if (errCode != GL_NO_ERROR)
	{
		String error ;
		switch (errCode)
		{
		case GL_INVALID_ENUM:
			error = "GL_INVALID_ENUM" ;
			break ;
		case GL_INVALID_VALUE:
			error = "GL_INVALID_VALUE" ;
			break ;
		case GL_INVALID_OPERATION:
			error = "GL_INVALID_OPERATION" ;
			break ;
		case GL_STACK_OVERFLOW:
			error = "GL_STACK_OVERFLOW" ;
			break ;
		case GL_STACK_UNDERFLOW:
			error = "GL_STACK_UNDERFLOW" ;
			break ;
		case GL_OUT_OF_MEMORY:
			error = "GL_OUT_OF_MEMORY" ;
			break ;
		}

		String errlog ;
		errlog.Format(String("OpenGL Error: ") + error + ": %s\n", (char *)gluErrorString((GLenum)errCode)) ;
		cerr << errlog ;

#ifdef WIN32
		MessageBox(NULL, _T((char *)gluErrorString((GLenum)errCode)), "OpenGL Error: " + error, MB_OK | MB_ICONSTOP) ;
#endif

		ExitProcedure(FAILURE) ;
	}
}


// ᥤ
#if !defined WIN32 || defined _CONSOLE
int main(int argc, char** argv)
{
	Option option(argc, argv) ;

	STATUS state;
	state = Initialize(option) ;
	if (state != SUCCESS)
		exit(EXIT_FAILURE) ;

	glutMainLoop() ;
	return EXIT_SUCCESS ;
}

#else
// Windows ᥤ
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	Option option(__argc, __argv) ;

	STATUS state ;
	state = Initialize(option) ;
	if (state != SUCCESS)
		exit(EXIT_FAILURE) ;

	glutMainLoop() ;
	return EXIT_SUCCESS ;
}
#endif
