// $Id: ishadowmap.H,v 1.2 2001/06/18 06:57:11 elca Exp $

#ifndef __ENV_GLASS_H__
#define __ENV_GLASS_H__

#ifdef   WIN32
#define  WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <tchar.h>

#define USE_TIME_GET_TIME
#ifdef USE_TIME_GET_TIME
#include <mmsystem.h>
#endif

//#define USE_PERFORMANCE_COUNTER
#ifdef USE_PERFORMANCE_COUNTER
#include <winbase.h>
#endif

#else
#include <unistd.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <time.h>

#include "Option.H"
#include "GLObject.H"
#include "PnmIO.H"


// ɥȥ
#define TITLE	        "Indexed Shadow Mapping -- 'H' Toggle Help Information"

#define VERSION_INFO	"IShadowMap-1.2"
#define AUTHOR		"September 2000 by Masa (Masaki Kawase)\n<E-Mail: masa@daionet.gr.jp>\n<http://www.daionet.gr.jp/~masa/>"

// ӥ塼ݥȤ饤Ȥˤ
// Υ饤ȤαƤϻѤʤʦƥȤ̵
#define DISABLE_LIGHT_VIEW_SHADOW

// ʿԸλϥ饤Ȥ褷ʤ
#define DISABLE_RENDER_PARALLEL_LIGHT

// FPS ׻
#define CALC_FPS_INTERVAL	1000

// ɽ٤礭ѤǽΤ硢ۤɡδֳ֤ FPS Ʒ׻Ԥ
#define SWITCH_FPS_INTERVAL	1

#define SPOT_IMAGE_FILE		"spot"
#define SPOT2_IMAGE_FILE	"spot2"
#define OBJECT_IMAGE_FILE	"object"
#define FLOOR_IMAGE_FILE	"floor.ppm"
#define GLOSS_IMAGE_FILE	"floor.pgm"
#define HELP_IMAGE_FILE		"help"

#define NM_VOLUME_LIGHT_PLANES		8
#define VOLUME_LIGHT_INTENSITY		0.75
#define VOLUME_LIGHT_INTENSITY_REF	(VOLUME_LIGHT_INTENSITY * 5.0)
#define VOLUME_LIGHT_NEAR_PLANE		0.7
#define VOLUME_LIGHT_FAR_PLANE		4.0

#define LIGHT_MAX_DISTANCE		16.0
#define LIGHT_PLANE_SIZE		0.4
#define LIGHT_STACK			24

// Ŭ
#define VOLUME_LIGHT_FORCE_SPOT_FOV	60.0

#define LIGHT_PARALLEL_SCALE		10.0

#define SHADOW_MAPPING_EDGE_FAT			0.05
#define SHADOW_MAPPING_EDGE_FAT_MIN		0.04
#define SHADOW_MAPPING_EDGE_FAT_TORUS_OUTER	0.075

#define DEFAULT_ALPHA_BIAS			-0.5

typedef int	STATUS ;

struct ObjectStatus
{
	RotateVector	angle ;
} ;

struct LightStatus
{
	Vector3d		position ;
	GLfloat			matrix[16] ;

	float			distance ;		// from center
	float			dbase ;
//	float			dangle ;
//	float			vdangle ;

	float			pitch ;		// pitch for center

	RotateVector	angle ;		// pitch yaw for position, roll
	RotateVector	angle2 ;	// distance, center pitch
} ;

#define MAX_LIGHTS	4
#define MAX_OBJECTS	5

#define MAX_MAX_LIGHTS	7

#define DEFAULT_LIGHTS	2
#define DEFAULT_OBJECTS	4


// ǥեȤΥɥ
#define WIDTH			480
#define HEIGHT			480

// ζΨ
#define REFRACTION_RATE	2.0f
//#define REFRACTION_RATE	2.4f

#define PER_VERTEX_FRESNEL	1

// 饹֥Ȥηʬ
#define GLASS_DIVIDE	16
#define TEAPOT_DETAIL	5

// ޥ
#define MOUSE_SPEED		160.0f

//#define START_SPIN_X	1.0f
//#define START_SPIN_Y	0.7f
#define START_SPIN_X	0.0f
#define START_SPIN_Y	0.0f

// OpenGLꤹƥ㎥ե륿
#define TEX_FILTER		GL_LINEAR_MIPMAP_LINEAR

// ºݤOpenGLꤹƥΥʣΣ
#define ENV_TEX_SIZE	8

// ޥ
#define MOUSE_FTP_RATIO	20.0f


// ؿץȥ

double GetErapsedTime() ;

STATUS Initialize(Option& option) ;
STATUS OpenGLInitialize(Option& option) ;

void CheckColorBuffer() ;
void CheckOpenGLEnvironment() ;

void ObjectInitialize() ;

void InitializeLights() ;

// OpenGL ΰŪ
void SetMiscParmeters() ;

void SetAlphaBias() ;

// ǥץ쥤ꥹ
void DefineDisplayList() ;
void DefineLightList() ;
void DefineObjectLists() ;
void DefineGroundList() ;
void DefineSpotCopyList() ;
void DefineReflectionTransformList() ;
void DefineVolumeLightLists() ;
void DefineVolumeLightList(int lNo) ;
void DefineHelpMessageList() ;

void DefineShadowMapTexEnvModeList() ;
void DefineGlossMapTexEnvModeList() ;

void RenderHelpMessage(float intensity) ;

void Draw3Cylinders(float radius, int alphaStartIndex, int shadowFlag = FALSE) ;
void DrawObject0(float radius, int alphaStartIndex, int shadowFlag = FALSE) ;

void DefineObject0List(int obj) ;
void DefineObject1List(int obj) ;
void DefineObject2List(int obj) ;
void DefineObject3List(int obj) ;
void DefineObject4List(int obj) ;

// ΥƥΥåȥå
void SetupTexture2D(const String& file, GLint wrap, GLint filter) ;
// ƥΥåȥå
void SetupTextures(Option& option) ;
// դƥΥåȥå
void SetupTexture2DWithAlpha(const String& file, const String& alphaFile, GLint wrap, GLint filter) ;

void DrawGround(int vFlag = FALSE,
		float *color0 = NULL,
		float *color1 = NULL,
		float *color2 = NULL,
		float *color3 = NULL,
		int shadowObj = FALSE) ;

void DrawLightPlane(int div, float radius, float z) ;
void DrawLightSourcePlane(int div, float radius, float z) ;

void DrawPerspectiveVolumeLight(int lNo, float intensity = 1.0) ;
void DrawParallelVolumeLight(int lNo, float intensity = 1.0) ;

// ߥХɤƤƥΥե륿򥻥å
void SetTextureFilter(GLint filter = GL_LINEAR_MIPMAP_LINEAR) ;

// ߥХɤƤƥκ򥻥å
void SetTextureMaxAnisotropy(GLfloat anisotropy = 1.0) ;

// ƤΥƥκ򥻥å
void SetAllTexturesMaxAnisotropy(GLfloat anisotropy = 1.0) ;

void LoadTextureImage(TRUEIMAGE **image, const String &name) ;

// image ƥ˥å
void SetTextureImage(TRUEIMAGE *image, String internalFormat = "RGB", int arrayComponents = 3) ;

STATUS GLUTInitialize(Option& option) ;
void SetGLUTCallback() ;

// Хåؿ
void ReshapeWindow(int x, int y) ;
void HandleKey(unsigned char key, int x, int y) ;
void ObjectProc() ;
void Redisplay() ;
void MouseProc(int button, int state, int x, int y) ;
void MouseMotion(int x, int y) ;
void FramesPerSecond(int value) ;

void MakeStatusString() ;
void UpdateStatusList(GLenum mode = GL_COMPILE) ;

// ơɽ
void DrawStatus() ;

// 
void ControlView() ;

// ֥Ȱư
void MoveObjects(int fixSpeed = FALSE) ;
void MoveLights(float msec) ;
void MovePolyhedron(float msec) ;

void GradationBG() ;

// 
void RenderScene() ;

// 
void Render() ;

void EnableAmbient() ;
void EnableDiffuse(int lNo) ;

// Хå顼ȾƩɤĤ֤
void DrawBackgroundColor(int n) ;

void RenderObjectsWithReflection() ;
void RenderObjects(int reflectMode = FALSE) ;

void RenderVolumeLights(int reflectMode = FALSE) ;
void RenderVolumeLight(int lNo, int reflectMode = FALSE) ;

void RenderLightObjects() ;
void RenderLightObject(int lNo) ;
void RenderLightObjectsAmbientPass() ;
void RenderLightObjectAmbientPass(int lNo) ;

void RenderPolyhedron(int reflectMode = FALSE) ;
void RenderLocalPolyhedron(int obj) ;

// ɥ֥ȥޥȥꥯ軻
void TransformWorld() ;

// 륪֥ȥޥȥꥯ軻
void TransformLocal(int obj) ;

// 饤ȥ֥ȥޥȥꥯ軻
void TransformLight(int lNo) ;

void UpdateLights() ;
void UpdateLight(int lNo) ;

void UpdateShadowMaps() ;
void UpdateShadowMap(int lNo) ;
void RenderObjectsForShadow(int lNo) ;
void RenderLightObjectsForShadow(int lNo) ;
void RenderLightObjectForShadow(int lNo) ;
void RenderPolyhedronForShadow() ;
void RenderLocalPolyhedronForShadow(int obj) ;

void SetLightViewAndProjection(int lNo) ;
void TransformLightView(int lNo) ;
void SetViewAndProjection(int vPoint = -1) ;

void SetProjectionTextureObject(int shadow) ;
void SetProjectionTextureEnvMode(int shadow) ;

void SetGlossMappingTextureEnvMode() ;
void SetShwdowMappingTextureEnvMode() ;

void InitializeShadowTextures() ;
void InitializeProjectionPlanes() ;


// Ūʥɥȥ륻å
// ôְŪ˥ȥ򥻥å
void SetTemporaryWindowTitle(const String& title, int wait = 3) ;

// ɥȥ륻å
// SetTemporaryWindowTitle()
// ξ硢ְʾФäƤʤ̵
void SetWindowTitle(const String& title) ;


// ǥץ쥤ꥹȤӥƥ͡
GLuint AllocAList(GLuint& list) ;
GLuint AllocATexture(GLuint& list) ;

void CheckOpenGLError() ;

// λ
void ExitProcedure(STATUS state = SUCCESS) ;


#endif
