// $Id: MString.cpp,v 1.3 2001/06/18 07:31:47 elca Exp $

#include "MString.H"


// 󥹥ȥ饯
String::String(int n)
{
	length = n ;

	if (n == 0) {
		str = NULL ;
		Clear() ;
	} else {
		allocated = ShouldAlloc(length) ;
		str = new char[allocated] ;
		memset(str, ' ', length) ;
		str[length] = '\0' ;
	}
}

String::String(const char *c)
{
//      cout << "String::String from const char * OK!!!!!!!" << endl ;

	length = strlen(c) ;
	if (length == 0) {
		str = NULL ;
		Clear() ;
		return ;
	}

	allocated = ShouldAlloc(length) ;
	str = new char[allocated] ;

	// ǽ餫̥뤬ͭΤḁ̇̄ɲ
	memcpy(str, c, length) ;
	str[length] = '\0' ; // Ǹ˥̥ʸղ
}

String::String(const char *c, int n)
{
//      cout << "String::String from const *char, int OK!!!!!!!" << endl ;

	int slen = strlen(c) ;

	length = n ;
	allocated = ShouldAlloc(length) ;
	str = new char[allocated] ;

	if (slen < length) {
        // ԡûϤޤ
		memcpy(str, c, slen) ;
		memset(&(str[slen]) , ' ', length - slen) ;
	} else {
		// ԡĹƱñɬʬԡ
		memcpy(str, c, length) ;
	}

	// Ǹ˥̥ʸɲ
	str[length] = '\0' ;
}

String::String(const String& s)
{
//    cout << "String::String from String OK!!!!!!!" << endl ;
//	if (this == &s) return ;

	length = s.length ;
	allocated = s.allocated ;

	str = new char[allocated] ;
	memcpy(str, s.str, length) ;
	str[length] = '\0' ; // Ǹ˥̥ʸղ

//    *this = String(s.str, s.length) ;
}

String::String(const String& s, int n)
{
//    cout << "String::String from String, int  OK!!!!!!!" << endl ;
	length = n ;
	allocated = ShouldAlloc(length) ;
	str = new char[allocated] ;

	if (s.length < length) {
		// ԡûϤޤ
		memcpy(str, s.str, s.length) ;
		memset(&(str[s.length]), ' ', length - s.length) ;
	} else {
		// ԡĹƱñɬʬԡ
		memcpy(str, s.str, length) ;
	}

	// Ǹ˥̥ʸɲ
	str[length] = '\0' ;

//    *this = String(s.str, n) ;
}

String::String(char c)
{
	str = NULL ;
	if (c == '\0') {
		str = NULL ;
		Clear() ;
	} else {
		length = 1 ;
		allocated = MIN_ALLOC_UNIT ;
		str = new char[allocated] ;
		str[0] = c ; str[1] = '\0' ;
	}
}


// ʸĹѲ;äʬ ' '
String& String::Length(int n)
{
	if (length == n) {
		return *this ;
	} else if (length > n) {
		// ûʤäȤ
		Realloc(n) ;
		length = n ;
		return *this ;
	} else {
		// ĹʤäȤΤߡʬ˶򥻥å
		Realloc(n) ;
		memset(&(str[length]), ' ', n - length) ;
//		str[n] = '\0' ;
		length = n ;
		return *this ;
	}

//    return (*this = String(str, n)) ;
}


// n ʸܤΣʸ
char String::Character(int n) const
{
	if (n < 1 || n > length) { return '\0' ; }
	return str[n - 1] ;
}

// n ʸܤʸѹ
String& String::SetAt(int n, char c)
{
	if (n > 0 && n <= length)
		str[n - 1] = c ;
	return *this ;
}


String& String::ReplaceString(char s, char d)
{
	for (int n = 1 ; n <= length ; n ++)
	{
		if (str[n - 1] == s)
			str[n - 1] = d ;
	}

	return *this ;
}

String& String::ReplaceString(const String& s, const String& d)
{
	if (this == &s || this == &d) return *this ;

	int pos = 1 ;
	while (TRUE) {
		int start = Search(s) ;

		if (start < pos || !start)
			break ;

		int rlen = length - (start + s.length - 1) ;
		String right ;
		if (rlen > 0)
			right = ::Right(*this, rlen) ;

		if (start == 1) {
			*this = d + right ;
		} else {
			Length(start - 1) ;
			*this += d + right ;
		}

		pos = start + d.Length() ;
	}

	return *this ;
}


// Lower, Upper
String& String::Lower()
{
	for (int i = 0 ; i < length ; i ++) {
		if (isupper(str[i]))
			str[i] = tolower(str[i]) ;
	}

	return *this ;
}

String& String::Upper()
{
	for (int i = 0 ; i < length ; i ++) {
		if (islower(str[i]))
			str[i] = toupper(str[i]) ;
	}

	return *this ;
}


// եޥå
String& String::Format(const char* format, ...)
{
	char buf[MAX_LINE_BUF] ;

	va_list args ;
	va_start(args, format) ;
//	int r = vsprintf(buf, format, args) ;
	vsprintf(buf, format, args) ;
	va_end(args) ;

	// ʸ󥻥å
	*this = buf ;
	return *this ;
}

// եޥå
String& String::AddFormat(const char* format, ...)
{
	char buf[MAX_LINE_BUF] ;

	va_list args ;
	va_start(args, format) ;
//	int r = vsprintf(buf, format, args) ;
	vsprintf(buf, format, args) ;
	va_end(args) ;

	// ʸ󥻥å
	*this += buf ;
	return *this ;
}


// ץ饤١
String& String::ReadAllLines(FILE *fp)
{
	while (TRUE)
	{
		char buf[MAX_LINE_BUF] ;
		char *s ;

		s = fgets(buf, MAX_LINE_BUF, fp) ;
		if (!s)
			break ;

		*this += s ;
	}
	return *this ;
}


// ƥȥեɤ߹
String& String::ReadFile(const String& fileName)
{
	FILE *fp ;
	fp = fopen(fileName, "r") ;

	if (!fp)
		*this = "" ;
	else
	{
		*this = ReadAllLines(fp) ;
		fclose(fp) ;
	}

	return *this ;
}


//-------------------------------------------------------------
// ȡ
// ֤줿ȡʺǽʸˤϺ
// String("") ֤ޤǷ֤
String String::Token(const String& delimiters, const String& comment)
{
	String	token ;

	// ΥȡΥȰ֤򸡺
	int start ;
	for (start = 1 ; start <= Length() ; start ++)
	{
		// ȹԥå
		if (::Mid(*this, start, comment.Length()) == comment)
		{
			// ȤʤԤκǸޤФ
			String right = ::Mid(*this, start, Length()) ;
			int next = right.Search('\n') ;

			if (next)
				start = next ;
			else	// ԤʤȤȤʸκǸ
				start = Length() ;

			continue ;
		}

		int flag = TRUE ;
		for (int c = 1 ; c <= delimiters.Length() ; c ++)
		{
			if (Character(start) == delimiters.Character(c))
			{
				flag = FALSE ;
				break ;
			}
		}

		// ǥߥΤɤȤޥåʤϷ
		if (flag)
			break ;
	}

	Mid(start, Length()) ;

	// Υȡνΰ֤򸡺
	int length ;
	for (length = 1 ; length <= Length() ; length ++)
	{
		// ȥåǥȤˤʤäƤϥȤľޤǡ
		if (::Mid(*this, length, comment.Length()) == comment)
			break ;

		// ǥߥΤɤ줫ĤǤޥåФľޤ
		int flag = FALSE ;
		for (int c = 1 ; c <= delimiters.Length() ; c ++)
		{
			if (Character(length) == delimiters.Character(c))
			{
				flag = TRUE ;
				break ;
			}
		}

		if (flag)
			break ;
	}

	length -- ;
	token = ::Left(*this, length) ;
	Mid(length + 1, Length()) ;

	return token ;
}


// m ʸܤ n ʸ
String& String::Mid(int m, int n)
{
	// ԡĹȰ֤Ŭ
	if (m < 1) m = 1 ;
	if (m > length || n < 0) return (this->Clear()) ;
	if (m + n > length + 1) n = length + 1 - m ;

	// ʣǽ뤿
	memmove(str, &(str[m - 1]), n) ;

	// ̵̤к
	Realloc(n) ;
	length = n ;
	str[length] = '\0' ;

	return *this ;
}

String Mid(String s, int m, int n)
{
    return (s.Mid(m, n)) ;
}

//  n ʸ
String& String::Left(int n)
{
    return (this->Mid(1, n)) ;
}
String Left(const String& s, int n)
{
    return (Mid(s, 1, n)) ;
}

//  n ʸ
String& String::Right(int n)
{
    if (n > length) n = length ;
    this->Mid(length + 1 - n, n) ;
	return *this ;
}
String Right(const String& s, int n)
{
    String  w = s ;
    return (w.Right(n)) ;
}

// ꤵ줿ե̾Υǥ쥯ȥʬ֤
// 鸡"/" ⤷ "\" μޤǤ֤
// "
String String::FileDirectory() const
{
#ifdef WIN32
	char dpath = '\\' ;
#else
	char dpath = '/' ;
#endif

	String dir ;

	int locate = length - 1 ;
	while (locate > 0 && str[locate - 1] != dpath) locate -- ;
	if (locate <= 0)
		dir = "" ;
	else
		dir = ::Left(*this, locate - 1) ;

	return dir ;
}

// ꤵ줿ե̾Υե͡ʬ֤
// 鸡"/" ⤷ "\" θΤߤ֤
// "
String String::FileNamePart() const
{
#ifdef WIN32
	char dpath = '\\' ;
#else
	char dpath = '/' ;
#endif

	String dir ;

	int locate = length - 1 ;
	while (locate > 0 && str[locate - 1] != dpath) locate -- ;
	if (locate <= 0)
		dir = str ;
	else
		dir = ::Right(*this, length - locate) ;

	return dir ;
}

// ʸ󥵡ʺǽ˰פ֤
int String::Search(const String& key, int start) const
{
	// ٤ʸĹ 0 ʤ FALSE
	if ((!key.length) || (length < start)) return FALSE ;

	// ʸĹ饭Ȥޤǥ
	for (int i = start ; i < length - (key.length - 1) ; i ++)
	{
		char tmp = key.str[0] ;
		if (tmp == str[i])
		{
			// ʸʤ餳λǳ
			if (key.length == 1)
				return (i + 1) ;
			// ʸʾξϤ˥
			else
			{
				int j ;
				for (j = 1 ; j < key.length ; j ++)
					if (str[i + j] != key.str[j]) break ;

				// ʸ֤Ƥг
				if (j == key.length)
					return (i + 1) ;
			}
		}
    }

	return FALSE ;
}
int String::Search(const char *key, int start) const
{
    return Search(String(key), start) ;
}
int String::Search(const char key, int start) const
{
    return Search(String(key), start) ;
}


// ڥ졼/ˤĤޤϡʸ򥵡פ֤
int String::operator /(const String& key) const
{
    if ((!key.length) || (!length)) return FALSE ; // ʸĹ 0 ʤ FALSE

    int     n = 0 ;

    // ʸĹ饭Ȥޤǥ
    for (int i = 0 ; i < length - (key.length - 1) ; i ++)
    {
		char tmp = key.str[0] ;
		if (tmp == str[i])
		{
		    // ʸʤ餳λǳ
		    if (key.length == 1)
				n ++ ;
			// ʸʾξϤ˥
		    else
		    {
				int j ;
				for (j = 1 ; j < key.length ; j ++)
				    if (str[i + j] != key.str[j]) break ;

				// ʸ֤Ƥг
				if (j == key.length)
			    n ++ ;
		    }
		}
    }

    return n ;
}
int String::operator /(const char *key) const
{
    return *this / String(key) ;
}
int String::operator /(const char key) const
{
    return *this / String(key) ;
}

//  String 
String NumToString(int i)
{
	String s;
	char buf[20];

	snprintf(buf, sizeof(buf), "%d", i);

	return s + buf;
}

String NumToString(float f)
{
	String s;
	char buf[64];

	snprintf(buf, sizeof(buf), "%f", f);

	return s + buf;
}

String NumToString(double d)
{
	String s;
	char buf[64];

	snprintf(buf, sizeof(buf), "%f", d);

	return s + buf;
}

// ڥ졼=黻
String& String::operator =(const String& s)
{
	if (this == &s) return *this ;

	Copy(s) ;
	return *this ;
}

String& String::operator =(const char *c)
{
	int clen = strlen(c) ;
	Realloc(clen) ;
	length = clen ;
	memcpy(str, c, length + 1);
	return *this ;
}

String& String::operator =(const char c)
{
	Realloc(1, FALSE) ;
	length = 1 ;
	str[0] = c ;
	str[1] = '\0' ;
	return *this ;
}

//-----------------------------------------------------------------------
// ʸӡʺǽ n ʸ s Ʊǡn 夬 s Ʊڤ
// String str ;
// str.Equ("abcde",3) Τ褦 ("abcde", 3) Ӥȡ
// str = "abc", str = "abcd", str = "abcde"  TRUE
// str  "abcde"5 ʸˤĹ FALSE
// n <= 0 ޤ άȡn = 1 Ʊ
int String::Equ(const String s, int n)
{
    if (n <= 0) n = 1 ;

    if (length > s.length || length < n) return FALSE ;
    String w = s ;
    w.Length(length) ;
    return (*this == w) ;
}

// n ʸ羮ӡstrncmp()Ʊn άȡstrcmp() Ʊ
int String::Cmp(const String s, int n)
{
    if (n < 0) return strcmp(str, s.str) ;
    else       return strncmp(str, s.str, n) ;
}

//============================================================================
// ڥ졼==, !=ӱ黻

//----------------------------------------------------------------------------
// String ƱΤ
int String::operator ==(const String& s2) const
{
	if (!strcmp(str, s2.str)) {
		return TRUE ;
	} else {
		return FALSE ;
	}
}

int String::operator !=(const String& s2) const
{
	if (strcmp(str, s2.str)) {
		return TRUE ;
	} else {
		return FALSE ;
	}
}

//-----------------------------------------------------------------------
// char * Ȥ
int String::operator ==(const char *c) const
{
    if (!strcmp(str, c)) return TRUE ;
    else                 return FALSE ;
}
int String::operator !=(const char *c) const
{
    if (strcmp(str, c)) return TRUE ;
    else                return FALSE ;
}

//--------------------------------------------------------------------
// char Ȥ
int String::operator ==(const char c) const
{
    if (length == 1 && str[0] == c) return TRUE ;
    else                            return FALSE ;
}
int String::operator !=(const char c) const
{
    return !(*this == c) ;
}

//-------------------------------------------------------------------
// դ char * Ȥ
int operator ==(const char *c, const String& s2)
{
    if (!strcmp(c, s2.str)) return TRUE ;
    else                    return FALSE ;
}
int operator !=(const char *c, const String& s2)
{
    if (strcmp(c, s2.str)) return TRUE ;
    else                   return FALSE ;
}

// դ char Ȥ
int operator ==(const char c, const String& s2)
{
    return (s2 == c) ;
}
int operator !=(const char c, const String& s2)
{
    return (s2 != c) ;
}


//============================================================================
// ڥ졼>, <, >=, <=羮ӱ黻

//---------------------------------------------------------------------------
// String ƱΤ
int String::operator >(const String& s2) const
{
    if (strcmp(str, s2.str) > 0) return TRUE ;
    else                         return FALSE ;
}
int String::operator <(const String& s2) const
{
    if (strcmp(str, s2.str) < 0) return TRUE ;
    else                         return FALSE ;
}
int String::operator >=(const String& s2) const
{
    if (strcmp(str, s2.str) >= 0) return TRUE ;
    else                          return FALSE ;
}
int String::operator <=(const String& s2) const
{
    if (strcmp(str, s2.str) <= 0) return TRUE ;
    else                          return FALSE ;
}

//------------------------------------------------------------------------
// char * Ȥ
int String::operator >(const char *c) const
{
    if (strcmp(str, c) > 0) return TRUE ;
    else                    return FALSE ;
}
int String::operator <(const char *c) const
{
    if (strcmp(str, c) < 0) return TRUE ;
    else                    return FALSE ;
}
int String::operator >=(const char * c) const
{
    if (strcmp(str, c) >= 0) return TRUE ;
    else                     return FALSE ;
}
int String::operator <=(const char *c) const
{
    if (strcmp(str, c) <= 0) return TRUE ;
    else                     return FALSE ;
}

//----------------------------------------------------------------------------
// char Ȥ
int String::operator >(const char c) const
{
    return (*this > String(c)) ;
}
int String::operator <(const char c) const
{
    return (*this < String(c)) ;
}
int String::operator >=(const char c) const
{
    return (*this >= String(c)) ;
}
int String::operator <=(const char c) const
{
    return (*this <= String(c)) ;
}

//-----------------------------------------------------------------------------
// դ char* Ȥ
int operator >(const char *c, const String& s2)
{
    if (strcmp(c, s2.str) > 0) {
	    return TRUE ;
    } else {
	    return FALSE ;
    }
}

int operator <(const char *c, const String& s2)
{
    if (strcmp(c, s2.str) < 0) {
	    return TRUE ;
    } else {
	    return FALSE ;
    }
}

int operator >=(const char *c, const String& s2)
{
    if (strcmp(c, s2.str) >= 0) {
	    return TRUE ;
    } else {
	    return FALSE ;
    }
}

int operator <=(const char *c, const String& s2)
{
    if (strcmp(c, s2.str) <= 0) {
	    return TRUE ;
    } else {
	    return FALSE ;
    }
}

//---------------------------------------------------------------------------
// դ char Ȥ
int operator >(const char c, const String& s2)
{
    return (String(c) > s2) ;
}
int operator <(const char c, const String& s2)
{
    return (String(c) < s2) ;
}
int operator >=(const char c, const String& s2)
{
    return (String(c) >= s2) ;
}
int operator <=(const char c, const String& s2)
{
    return (String(c) <= s2) ;
}


// ڥ졼()黻
String& String::operator ()(const String& s)
{
    return (*this = s) ;
}
String& String::operator ()(const char *c)
{
    return (*this = c) ;
}
String& String::operator ()(const char c)
{
    return (*this = c) ;
}


//===================================================================
// ڥ졼+, +=

// String ƱΤϢ
String String::operator +(const String& s) const
{
	String  w(str, length + s.length) ;

//       for (int i = 0 ; i < s.length ; i ++) w.str[i + length] = s.str[i] ;
	memcpy(&(w.str[length]), s.str, s.length) ;

	return w ;
}
// դ char * ȤϢ
String String::operator +(const char *s) const
{
	int slen = strlen(s) ;
	String  w(str, length + slen) ;

//       for (int i = 0 ; i < slen ; i ++) w.str[i + length] = s[i] ;
	memcpy(&(w.str[length]), s, slen) ;

	return w ;
}
// դ char ȤϢ
String String::operator +(const char s) const
{
	String w(str, length + 1) ;
	w.str[w.length - 1] = s ;
	return w ;
}

// դ char * ȤϢ
String operator +(const char *d, const String& s)
{
	int     dlen = strlen(d) ;
	String  w(d, dlen + s.length) ;
	for (int i = 0 ; i < s.length ; i ++) { w.str[i + dlen] = s.str[i] ; }
	return w ;
}

// դ char ȤϢ
String operator +(const char d, const String& s)
{
    String wd(d), w(wd, s.length + 1) ;
    for (int i = 0 ; i < s.length ; i ++) { w.str[i + 1] = s.str[i] ; }
    return w ;
}

// Ϣ
String& String::operator +=(const String& s)
{
	if (this == &s) {
		*this += String(s) ;
		return *this ;
	}

	Realloc(length + s.length) ;
	memcpy(&(str[length]), s.str, s.length + 1) ;
	length += s.length ;

	return *this ;
}

String& String::operator +=(const char *s)
{
	int slen = strlen(s) ;
	Realloc(length + slen) ;
	memcpy(&(str[length]), s, slen + 1) ;
	length += slen ;

	return *this ;

}
String& String::operator +=(const char c)
{
	Realloc(length + 1) ;
	length ++ ;
	str[length - 1] = c ;
	str[length] = '\0' ;

	return *this ;
}


// ڥ졼*, *=
String String::operator *(int n)
{
	String s(length * n) ;
	for (int i = 0 ; i < n ; i ++)
		memcpy(&(str[length * i]), str, length) ;
	length *= n ;
	return s ;
}

String& String::operator *=(int n)
{
	Realloc(length * n) ;
	for (int i = 1 ; i < n ; i ++)
		memcpy(&(str[length * i]), str, length) ;
	length *= n ;
	return *this ;

}

// ϥڥ졼
ostream& operator <<(ostream& os, const String& s)
{
    os << s.str ;
    return os ;
}

istream& operator >>(istream& is, String& s)
{
    is >> s.str ;
    return is ;
}


// ĥ

// ʸڤͤʱ¦ޤϲԤޤTABʤ
String& String::Cut()
{
    int  i ;
    for (i = length ; i >= 1 ; i --) {
	if (!isspace(Character(i))) break ;
    }
    Length(i) ; // ʸĹڤͤ

    return *this ;
}


// ʸڤͤʱ¦ޤϲԤޤTABʤ
String& Cut(String s)
{
    return s.Cut() ;
}

// ʸڤͤʱ¦ޤϲԤޤTABʤ
String& Cut(const char *s)
{
    String tmp(s) ;
    return tmp.Cut() ;
}


#ifdef OVERRIDE_NEW_OPERATOR

//
//      Ρɹ¤
//
typedef struct memnode_tag
{
        struct memnode_tag      *pNext;
        unsigned long                        dwSize;
        int                                     pMem[1];
} MEMNODE;

// ¤ΤΥإåʬΥ
#define MEMNODE_HDRSIZE (sizeof(MEMNODE*) + sizeof(unsigned long))


//
//      ϥåơ֥Ϣ
//
// ϥåơ֥礭ʣ߾Ǥ뤳Ȥɬܡ
//#define HASHTABLE_SIZE  0x1000
#define HASHTABLE_SIZE  0x1000

// ϥåơ֥
static MEMNODE memtbl[HASHTABLE_SIZE];

// ݥ󥿤ϥå奭륤饤ؿ
static inline unsigned long GetHashKey( void* p )
{
        return (int)p & (HASHTABLE_SIZE - 1);
}


//
//      ǡ
//
// ׵ʼԴޤ
static int nAllocCtr = 0;

// ե꡼׵ʼԴޤ
static int nFreeCtr = 0;

// ȼԲ
static int nAllocFail = 0;

// ե꡼Բ
static int nFreeFail = 0;

// NULL ե꡼
static int nFreeNull = 0;

// ߤΥ̡ñ¡
static int nAllocAmt = 0;

// Υ
static int nAllocAmtMax = 0;

// Ūåλ
static int isChecked = FALSE ;


// ̤ơ֥
#define MAX_UNFREE_TABLE 10000
static int nLeaks ;
static MEMNODE *unfree[MAX_UNFREE_TABLE] ;


//
//      С饤ɤnew黻
//
void* :: operator new( size_t n )
{
        MEMNODE*        pNewNode;
        MEMNODE*        pNode;
        unsigned long           nKey;

		if (!nAllocCtr) {
			for (int i = 0 ; i < HASHTABLE_SIZE ; i ++) {
				memtbl[i].pNext = NULL ;
			}
		}

        nAllocCtr++;

        // Ȥꤢΰ
        pNewNode = (MEMNODE*)malloc( n + sizeof(MEMNODE) );
        if ( pNewNode == NULL ) {
                nAllocFail++;
                return NULL;
        }

        pNewNode->pNext = NULL;
        pNewNode->dwSize = n;

        // ̤ν
        nAllocAmt += n;
        if ( nAllocAmt > nAllocAmtMax ) nAllocAmtMax = nAllocAmt;

        // ϥåơ֥ƬΥȥ
        nKey    = GetHashKey(pNewNode);
        pNode   = &memtbl[nKey];

        // ϢκǸ򤿤
        while ( pNode->pNext != NULL ) {
                pNode = pNode->pNext;
        }

        // ϢκǸ pNewNode ɲ
        pNode->pNext = pNewNode;

        // pMemݤ줿ΰȤʤ
        return (void*)pNewNode->pMem;
}



//
//      С饤ɤdelete黻
//
void :: operator delete( void* p )
{
        MEMNODE*        pDelNode;
        MEMNODE*        pNode;
        int                     nKey;

        nFreeCtr++;

	if (!p) {
		nFreeFail ++ ;
		nFreeNull ++ ;
		return ;
	}
        
        // ݥpΡɤΥݥ󥿤򻻽Ф
        pDelNode = (MEMNODE*)((int)p - MEMNODE_HDRSIZE);

	if (isChecked) {
		for (int i = 0 ; i < nLeaks ; i ++) {
			if (unfree[i] == pDelNode) {
				unfree[i] = NULL ;
				free(pDelNode) ;
			}
		}

		FILE *fp = fopen("leakcheck.log", "w") ;
		if (fp) {
			for (int i = 0 ; i < nLeaks ; i ++) {
				if (unfree[i]) {
					fprintf(fp, "leak: address: 0x%lX\n", (int)unfree[i]) ;
				}
			}
			fprintf(fp, "delete request: %ld\n", nFreeCtr) ;
			fclose(fp) ;
		}
		return ;
	}

	if ((int)pDelNode == 0x00d729d0) {
		pDelNode = pDelNode ;
	}

        // pDelNodeϥå奭
        nKey = GetHashKey(pDelNode);
        
        // ϥåơ֥ꡤpDelNodeΰΥΡɤ򤿤
        pNode = &memtbl[nKey];
        while ( pNode->pNext != pDelNode && pNode->pNext != NULL ) {
                pNode = pNode->pNext;
        }

        // ΡɤĤʤäνʥ顼
        if ( pNode->pNext == NULL ) {
                nFreeFail++;
                return;
        }

        // ϢηҤľ
        pNode->pNext = pDelNode->pNext;

        // ΰγ
        nAllocAmt -= pDelNode->dwSize;
        free(pDelNode);
}



//
//      ׽
//
void MemDebugFinal()
{
        char    pStrBuf[256];
        int             i;
	int     leakBytes = 0 ;

	isChecked = TRUE ;
	for (i = 0 ; i < MAX_UNFREE_TABLE ; i ++) {
		unfree[i] = NULL ;
	}

	nLeaks = 0 ;

        // ϥåơ֥̤ΰ褬äٹɽ
        for ( i=0 ; i<HASHTABLE_SIZE ; i++ ) {
                MEMNODE* pNode = memtbl[i].pNext;

                while ( pNode ) {
                        MEMNODE* pNext = pNode->pNext;
                        sprintf( pStrBuf, ">> Memory leak found!!  address:%lX  %d bytes\r\n", (int)pNode, (int)pNode->dwSize) ;
			leakBytes += pNode->dwSize ;

			unfree[nLeaks] = pNode ;
			nLeaks ++ ;

                        pNode = pNext;
                }
        }
}


#endif	// #ifdef OVERRIDE_NEW_OPERATOR
