// $Id: MString.H,v 1.3 2001/06/18 07:32:05 elca Exp $
// ======================================================================== //
//                                                                          //
//                         String 饹ե                        //
//                                                                          //
//                               饹 String                              //
//                                                                          //
//                                                                          //
//                            ʸ饹                          //
//                                                                          //
//                                                                          //
//                                                                          //
//  Ϣե :                                                          //
//    "MString.H" : 饹ڤӥ饤ؿʤΥե      //
//                ץꥱ 󥯥롼ѥե                   //
//    "MString.cpp"     : ¾δؿ                                  //
//                                                                          //
//  󥹥ȥ饯 :                                                        //
//    String() : ̥ʸǽ                                           //
//    String(int n) : n ʸĹΥڡǽ                            //
//    String(char *c) : ʸ c ǽ                                   //
//    String(char *c, int n) : ʸ c ǽĹ϶Ū n ʸ     //
//        ;äϡڡޤ                                    //
//    String(String s, int n) : String ֥ȤȤʳϾƱ     //
//    String(String s) : String ֥ȥԡ                          //
//                                                                          //
//                                                                          //
//  st  String 饹Υ֥ȤȤString st ;                  //
//                                                                          //
//  ᥽å :                                                              //
//    int st.Length() : ʸĹ֤                                      //
//    String& st.Length(n) : ʸĹ򥻥åȡ;äϥڡ       //
//                                                                          //
//    st = String, st = (char*)                                       //
//                                                                          //
//    ʹߤΥ᥽åɤǡ                                                    //
//    Mid(), Left(), Right() ϡĹ᤮;äʬϵͤûʤ     //
//    󥹥ȥ饯Ȱ㤤st Ĺ  n ˤʤȤϸ¤ʤ           //
//                                                                          //
//    st.Mid(int m, n) : st m ʸܤ n ʸʬʸѲ         //
//    Mid(st, int m, n) : st Ρm ʸܤ n ʸʬФ            //
//                                                                          //
//    st.Left(int n) : st 򡢺 n ʸʬʸѲ                 //
//        Length(n) Ȥΰ㤤ϡst Ϥ߽ФʬϥåȤ뤳     //
//        Length(n) Ǥ Ĺɬ n ˡϤ߽Фʬϥڡޤ  //
//    Left(st, n) : st Ρ n ʸʬФ                        //
//                                                                          //
//    st.Right(int n) : st 򡢱 n ʸʬʸѲ                //
//    Right(st, n) : st Ρ n ʸʬФ                       //
//                                                                          //
//                                                                          //
//  ӱ黻 :                                                            //
//    ==, !=, <, >, <=, <= : ʸ                                   //
//        ϡξ String ޤϡString  char*               //
//                                                                          //
//  ϥڥ졼 :                                                      //
//    <<, >>                                                                //
//                                                                          //
//                                                                          //
// ======================================================================== //


#ifndef ___STRING_H___
#define ___STRING_H___

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>

#include "Define.H"


//#define STRING_DEBUG

// ХǼޤ 10 Τ٤κ͡IntToString() ǻѡ
#define MAX_DIV_DEF   1000000000


class String
{
	enum
	{
		MIN_ALLOC_UNIT = 64,
		MAX_ALLOC_UNIT = 4096,
		MAX_LINE_BUF   = 16384,
	} ;

    int     length ;
	int     allocated ;
    char    *str ;

	// Υꥢ
    inline String& Clear()
	{
		if (str) delete [] str ;
		length = 0 ;
		str = new char[1] ;
		str[0] = '\0' ;
		allocated = 1 ;
		return *this ;
	}

	// n ʸºݤ˳ݤ٤
	// n ŪʸĹ
	inline static int ShouldAlloc(int n)
	{
		if (n < MIN_ALLOC_UNIT)
			return MIN_ALLOC_UNIT ;
		else
		{
			if ((n + 1) * 2 > MAX_ALLOC_UNIT)
				return n + 1 + MAX_ALLOC_UNIT ;
			else
				return (n + 1) * 2 ;
		}
	}

	// Ƴ
	// Хåե­ʤ
	//   ݤƥԡ
	//
	// ­Ƥ
	//   ɬ̤ܰʾ夢
	//   ɬ̤ܤޤǺ
	//   ¥ǡĹ length ǽΤ
	//
	// n ϡɬפʸĹ
	// ΥʸĹ
	//
	// guarantee  FALSE ꤵƤ
	// ǡΥԡϼ¹Ԥʤ
	inline void Realloc(int n, int guarantee = TRUE)
	{
#ifdef STRING_DEBUG
		cout << "String::Realloc(" << n << ", " << guarantee << ")" << endl ;
#endif
		if (n == length) return ;

		if (n + 1 > allocated)
		{
			// ɬ̤ܳݤ
			// ɬ̤ܤ MAX_ALLOC_UNIT Ķ
			// ɬ̡MAX_ALLOC_UNIT ʬݤ
			allocated = ShouldAlloc(n) ;
//			if ((n + 1) * 2 > MAX_ALLOC_UNIT)
//				allocated = n + 1 + MAX_ALLOC_UNIT ;
//			else
//				allocated = (n + 1) * 2 ;

			char *w = new char[allocated] ;

			if (guarantee)
			{
				// ¥ǡʤĤޤʸĹܣ
				// length + 1 Хȥԡ
				//  length  n ¿ n ɤ
				if (length > n)
				{
					memcpy(w, str, n) ;
					w[n] = '\0' ;
				}
				else
					memcpy(w, str, length + 1) ;
			}

			// Ǹ˥Хåե
			delete [] str ;
			str = w ;
		} else {
			// Хåեޤ
			// ºݤɬ̤ܤĶƤ
			// ɬ̤ܡǤ MIN_ALLOC_UNIT ˥Хåե
			// ¥ǡĹ length ǽΤ
			if ((n + 1) * 2 < allocated) {
				// ɬ̤ܤޤǥǡ
				// ɬ̤ܤ MAX_ALLOC_UNIT Ķ
				// ɬ̡MAX_ALLOC_UNIT ʬݤ
				if ((n + 1) * 2 > MAX_ALLOC_UNIT)
					allocated = n + 1 + MAX_ALLOC_UNIT ;
				else if ((n + 1) * 2 < MIN_ALLOC_UNIT)
					allocated = MIN_ALLOC_UNIT ;
				else
					allocated = (n + 1) * 2 ;

				char *w = new char[allocated] ;

				if (guarantee) {
					// θɬפˤʤǡn
					// ʤ n Хȥԡ
					// ⤷̤ n + 1 ­ʤ
					// ­ʬޤǤ򥳥ԡ
					//
					// n ʸκǸˤϥ̥ʸɲ
					if (n + 1 > allocated)
					{
						memcpy(w, str, allocated - 1) ;
						w[allocated - 1] = '\0' ;
					}
					else
					{
						memcpy(w, str, n) ;
						w[n] = '\0' ;
					}
				}

				// Ǹ˥Хåե
				delete [] str ;
				str = w ;
			}
		}
	}

	// ǡΥԡ
	// ԡ򸵤˺ƳݤƤǡ򥳥ԡ
	inline void Copy(const String& s)
	{
		if (this == &s) return ;

		// ɬפʾϺƳ
		// ʤȤ⥳ԡ s.length ʬΥǡݾڤ
		// ǡΥԡɬפʤΤ FALSE Ϥ
		Realloc(s.length, FALSE) ;

		// ºݤΥǡԡ
		length = s.length ;
		memcpy(str, s.str, s.length) ;

		// ǸϰŪ˥̥ʸɲ
		str[length] = '\0' ;
	}

	String& ReadAllLines(FILE *fp) ;

  public:

    // 󥹥ȥ饯
    String()
	{
		str = NULL ;
		Clear() ;
	}

    String(int n) ;
//    String(char *c, int n = -1) ;
    String(const char *c) ;
    String(const char *c, int n) ;// = -1) ;
    String(const String &s) ;
    String(const String &s, int) ;// n = -1) ;
    String(char c) ;

    // ǥȥ饯
    ~String() { if (str) delete [] str ; }

    // 㥹ȱ黻ҡchar*
//#ifdef WIN32
	inline operator char*() const { return str ; }
//#else
//	const operator char*() const { return str ; }
//#endif

    // 
    inline int Length() const { return length ; }

    // ʸĹѲ;äʬϥڡ ' '
    String& Length(int n) ;

    // n ʸܤΣʸ
    char Character(int n = 1) const ;

	// n ʸܤʸѹ
	String& SetAt(int n, char c) ;

	String& ReplaceString(char s, char d) ;
	String& ReplaceString(const String& s, const String& d) ;
	inline String& ReplaceString(const String& s, char d) { ReplaceString(s, String(d)) ; return *this ; }
	inline String& ReplaceString(const char s, const String& d) { ReplaceString(String(s), d) ; return *this ; }

	// Lower, Upper
	String& Lower() ;
	inline friend String Lower(const String& s) { String w = s ; w.Lower() ; return w ; }
	String& Upper() ;
	inline friend String Upper(const String& s) { String w = s ; w.Upper() ; return w ; }

	// եޥå
	String& Format(const char* format, ...) ;

	// եޥåȤɲ
	String& AddFormat(const char* format, ...) ;

	// ƥȥեɤ߹
	String& ReadFile(const String& fileName) ;

	// ȡ
	// ֤줿ȡʺǽʸˤϺ
	// String("") ֤ޤǷ֤

#define __STRING_DEFAULT_TOKEN_DELIMITERS	" \t\n"
#define __STRING_DEFAULT_TOKEN_COMMENT		"//"

//#ifdef macintosh
	// for Mac
	String Token(const String &delimiters , const String& comment) ;
	inline String Token(const String &delimiters) { return Token(delimiters, String(__STRING_DEFAULT_TOKEN_COMMENT)) ; }
	inline String Token() { return Token(String(__STRING_DEFAULT_TOKEN_DELIMITERS), String(__STRING_DEFAULT_TOKEN_COMMENT)) ; }

//#else	// #ifdef macintosh
//	String Token(const String& delimiters = String(__STRING_DEFAULT_TOKEN_DELIMITERS),
//				 const String& comment = String(__STRING_DEFAULT_TOKEN_COMMENT)) ;
//
//#endif	// #ifdef macintosh ... #else

    // m ʸܤ n ʸ
    String& Mid(int m, int n = 1) ;
    friend String Mid(String s, int m, int n = 1) ;

    //  n ʸ
    String& Left(int n = 1) ;
    friend String Left(const String& s, int n = 1) ;

    //  n ʸ
    String& Right(int n = 1) ;
    friend String Right(const String& s, int n = 1) ;

	String FileDirectory() const ;
	String FileNamePart() const ;

    // ʸ󥵡ʺǽ˰פ֤
    int Search(const String& key, int start = 0) const ;
    int Search(const char   *key, int start = 0) const ;
    int Search(const char    key, int start = 0) const ;

/*
    // ʸ󥵡ʺǽ˰פ֤
    int Search(const String& key) const ;
    int Search(const char   *key) const ;
    int Search(const char    key) const ;
*/

    // ڥ졼/ˤĤޤϡʸ򥵡פ֤
    int operator /(const String& key) const ;
    int operator /(const char   *key) const ;
    int operator /(const char    key) const ;

    // ڥ졼=黻
    String& operator =(const String& s) ;
    String& operator =(const char   *c) ;
    String& operator =(const char    c) ;

    // ʸӡʺǽ n ʸ s Ʊǡn 夬 s Ʊڤ
    // ޥɥץΥʤɤǻ
    int Equ(const String s, int n = 1) ;

    // n ʸ羮ӡstrncmp()Ʊn άȡstrcmp() Ʊ
    int Cmp(const String s, int n = -1) ;

    // ڥ졼==, !=ӱ黻
    int operator ==(const String& s2) const ;
    int operator !=(const String& s2) const ;
    int operator ==(const char    *c) const ;
    int operator !=(const char    *c) const ;
    int operator ==(const char     c) const ;
    int operator !=(const char     c) const ;
    friend int operator ==(const char *c, const String& s2) ;
    friend int operator !=(const char *c, const String& s2) ;
    friend int operator ==(const char  c, const String& s2) ;
    friend int operator !=(const char  c, const String& s2) ;

    // ڥ졼>, <, >=, <=ӱ黻
    int operator > (const String& s2) const ;
    int operator < (const String& s2) const ;
    int operator >=(const String& s2) const ;
    int operator <=(const String& s2) const ;
    int operator > (const char    *c) const ;
    int operator < (const char    *c) const ;
    int operator >=(const char    *c) const ;
    int operator <=(const char    *c) const ;
    int operator > (const char     c) const ;
    int operator < (const char     c) const ;
    int operator >=(const char     c) const ;
    int operator <=(const char     c) const ;
    friend int operator > (const char *c, const String& s2) ;
    friend int operator < (const char *c, const String& s2) ;
    friend int operator >=(const char *c, const String& s2) ;
    friend int operator <=(const char *c, const String& s2) ;
    friend int operator > (const char  c, const String& s2) ;
    friend int operator < (const char  c, const String& s2) ;
    friend int operator >=(const char  c, const String& s2) ;
    friend int operator <=(const char  c, const String& s2) ;

    // ڥ졼()黻
    String& operator ()(const String& s) ;
    String& operator ()(const char   *c) ;
    String& operator ()(const char    c) ;

    // ڥ졼+, +=
    String operator +(const String& s) const ;
    String operator +(const char   *s) const ;
    String operator +(const char    c) const ;
    friend String operator +(const char *d, const String& s) ;
    friend String operator +(const char  d, const String& s) ;
    String& operator +=(const String& s) ;
    String& operator +=(const char   *s) ;
    String& operator +=(const char    c) ;

    // ڥ졼*, *=
    String operator *(int n) ;
    String& operator *=(int n) ;

    // ϥڥ졼
    friend ostream& operator <<(ostream& os, const String& s) ;
    friend istream& operator >>(istream& is, String& s) ;


    // ĥ

    // ʸڤͤʱ¦ޤϲԤޤTABʤ
    String& Cut() ;
    friend String& Cut(String      s) ;
    friend String& Cut(const char *s) ;
} ;

//  String 
String NumToString(int i);
String NumToString(float f);
String NumToString(double d);

#ifdef OVERRIDE_NEW_OPERATOR
void MemDebugFinal() ;
#endif	// #ifdef OVERRIDE_NEW_OPERATOR


#endif
