;;
;; Readline test
;;
;; By YOKOTA Hiroshi

(use gauche.test)
(use readline)
(test-section "readline")

(test-module 'readline)

(define histfile "./test-history")

(sys-unlink histfile)

(test "rl-read-history! :file not found" 'unused
      (lambda ()
	(rl-read-history! histfile))
      (lambda (expect result) (not (= result 0))))

(test "rl-write-history :write success" 0
      (lambda ()
	(rl-add-history! "1")
	(rl-add-history! "2")
	(rl-add-history! "3")
	(rl-write-history histfile)
	))

(test "rl-read-history! :read success" 0
      (lambda ()
	(rl-read-history! histfile)))

(sys-chmod histfile #o000)

(test "rl-write-history :can't write" 'unused
      (lambda ()
	(rl-write-history histfile))
      (lambda (expect result) (not (= result 0))))


(test "rl-read-history! :can't read" 'unused
      (lambda ()
	(rl-read-history! histfile))
      (lambda (expect result) (not (= result 0))))

(test* "rl-set-name! #t" *test-error* (rl-set-name! #t))
(test* "rl-set-name!  1" *test-error* (rl-set-name! 1))
(test* "rl-set-name! 'a" *test-error* (rl-set-name! 'a))

(sys-unlink histfile)

(test-end)

;; end
