;;
;; Readline test
;;
;; By YOKOTA Hiroshi

(use gauche.test)
(use readline)
(test-section "readline")

(test-module 'readline)

(define histfile "./test-history")

(sys-unlink histfile)

(test "read-history! :file not found" 'unused
      (lambda ()
	(read-history! histfile))
      (lambda (expect result) (not (= result 0))))

(test "write-history :write success" 0
      (lambda ()
	(add-history! "1")
	(add-history! "2")
	(add-history! "3")
	(write-history histfile)
	))

(test "read-history! :read success" 0
      (lambda ()
	(read-history! histfile)))

(sys-chmod histfile #o000)

(test "write-history :can't write" 'unused
      (lambda ()
	(write-history histfile))
      (lambda (expect result) (not (= result 0))))


(test "read-history! :can't read" 'unused
      (lambda ()
	(read-history! histfile))
      (lambda (expect result) (not (= result 0))))

(test* "set-readline-name! #t" *test-error* (set-readline-name! #t))
(test* "set-readline-name!  1" *test-error* (set-readline-name! 1))
(test* "set-readline-name! 'a" *test-error* (set-readline-name! 'a))

(sys-unlink histfile)

(test-end)

;; end
