;;
;; readline module
;;
;; by: YOKOTA Hiroshi

(define-module readline
  (use gauche.uvector)
  (use gauche.vport)
  (export make-readline-input-port
	  rl-readline
	  rl-set-name!
	  rl-add-history! rl-read-history! rl-write-history rl-stifle-history!))
(select-module readline)

(dynamic-load "readline")

(define (make-readline-input-port . prompt)
  (make <buffered-input-port>
    :fill (lambda (vec)
	    (let1 line (rl-readline (if (null? prompt)
					""
					(car prompt)))

		  (if (string? line)
		      (let* ((rlvec (string->u8vector line))
			     (len   (u8vector-length  rlvec)))

			(if (not (= (string-length line) 0))
			    (rl-add-history! line))

			(u8vector-copy! vec 0 rlvec)

			;; Add #\newline for line separator. Then add
			;; 1 to length and exits this function with
			;; length value.
			(u8vector-set! vec len (char->integer #\newline))
			(+ len 1))

		      0)))))

(provide "readline")

;; end
