;; -*- mode: scheme -*-
;;
;; Gauche interactive session with readline support.
;;
;; By: YOKOTA Hiroshi

(use readline)
(use gauche.interactive)

;; useful functions from gauche.interactive
(define /i info)
(define /d describe)
(define /a (lambda (obj)
	     (let1 key (if (string? obj)
			   (string->regexp obj)
			   obj)
		   (apropos key))))

(define (main args)
  (let ((readline-port (make-readline-input-port "gosh-rl> "))
	(histfile (string-append (or (sys-getenv "HOME") ".")
				 "/.gosh_history")))

    (dynamic-wind
        (lambda ()
	  (rl-set-name!       "Gauche")
	  (rl-stifle-history! 1000)
	  (rl-read-history!   histfile))
	(lambda ()
	  (read-eval-print-loop (lambda () (read readline-port))
				#f
				#f
				(lambda () #f)))
	(lambda ()   
	  (rl-write-history histfile)))

    0))

;; end
