#!/usr/bin/gosh
;;
;; Make prefetch URL for cyber-earth-cache.cgi
;;
;;
;; Usage: make-cache-url.scm <maplevel> <w> <s> <e> <n> | wget -i -
;;
;; <maplevel>: map level in [second * 100]
;; <w>,<s>,<e>,<n>: map BBOX in [degree]
;;

(use util.list)
(use srfi-1)

(define (degree->second100 val)
  (* val 60 60 100))
(define (string->second100 val)
  (degree->second100 (string->number val)))

(define (reshape-bbox level nsec esec wsec ssec)
  (let (
	(rn (* (+ (floor (/ nsec level)) 1) level))
	(rs (* (- (floor (/ ssec level)) 1) level))
	(re (* (+ (floor (/ esec level)) 1) level))
	(rw (* (- (floor (/ wsec level)) 1) level))
	)
    `((n . ,rn) (e . ,re) (w . ,rw) (s . ,rs))
  ))

(define (main *args*)
  (let* ((lev (string->number (list-ref *args* 1)))
	 (w   (string->second100 (list-ref *args* 2)))
	 (s   (string->second100 (list-ref *args* 3)))
	 (e   (string->second100 (list-ref *args* 4)))
	 (n   (string->second100 (list-ref *args* 5)))
	 (sbbox #f)
	 (latpos 0) (lonpos 0))

    (set! sbbox (reshape-bbox lev n e w s))

    (set! latpos (assoc-ref sbbox 's))
    (while (< latpos (assoc-ref sbbox 'n))
	   (set! lonpos (assoc-ref sbbox 'w))
	   (while (< lonpos (assoc-ref sbbox 'e))
		  (format #t "http://localhost/cgi-bin/cyber-earth-cache.cgi?filename=/data/~0d/new/~0d/~0d-~0d-img.png\n" (exact->inexact (/ lev 100)) lonpos lonpos latpos)
		  (inc! lonpos lev)
		  )
	   (inc! latpos lev)
	   )
    
    ))

;; end
