#!/usr/bin/gosh
;; -*- mode: scheme -*-
;;
;; Cyber Earth
;;
;; By: YOKOTA Hiroshi

(use www.cgi)
(use sxml.serializer)
(use util.list)
(use srfi-1)

(define (degree->second100 val)
  (* val 60 60 100))
(define (second100->degree val)
  (/ val (* 60 60 100)))
(define (second100->degree-i val)
  (exact->inexact (second100->degree val)))

;; maximum bbox of Cyberjapan data
(define *max-bbox* `((n . ,(degree->second100  46.5))
		     (e . ,(degree->second100 154  ))
		     (w . ,(degree->second100 121  ))
		     (s . ,(degree->second100  20.2))))

(define *direct-mode-file* "/tmp/cyber-earth-direct")

(define (direct-mode?)
  (file-exists? *direct-mode-file*))

(define (make-pos-list start step limit)
  (let ((p start) (l '()))
    (while (< p limit)
	   (push! l p)
	   (inc! p step))
    l
    ))

(define (detect-maplevel nsec esec wsec ssec)
  (let ((l (abs (- esec wsec))))
    (cond ((< l      6000)     750)
	  ((< l     10000)    1500)
	  ((< l     15000)    3000)
	  ((< l     22000)    6000)
	  ((< l     28000)   12000)
	  ((< l     38000)   24000)
	  ((< l    100000)   48000)
	  ((< l    200000)   96000)
	  ((< l    400000)  192000)
	  ((< l   1000000)  384000)
	  ((< l   3000000)  768000)
	  ((< l  10000000) 1536000)
	  ((< l 100000000) 3072000)
	  (else            3072000))))

(define (detect-maplevel-r range tilt)
  (let ((l range))
    (cond ((< l    1000)     750)
	  ((< l    2000)    1500)
	  ((< l    4000)    3000)
	  ((< l    8000)    6000)
	  ((< l   16000)   12000)
	  ((< l   32000)   24000)
	  ((< l   64000)   48000)
	  ((< l  128000)   96000)
	  ((< l  256000)  192000)
	  ((< l  512000)  384000)
	  ((< l 1024000)  768000)
	  ((< l 2048000) 1536000)
	  ((< l 4096000) 3072000)
	  (else          3072000))))

;; reshape minimum bbox from lat/lon and maplevel
(define (reshape-bbox level nsec esec wsec ssec latsec lonsec)
  (let (
	(rn (min (* (+ (floor (/ nsec   level)) 1) level)
		 (* (+ (floor (/ latsec level)) 4) level)
		 (degree->second100 90)))
	(rs (max (* (- (floor (/ ssec   level)) 1) level)
		 (* (- (floor (/ latsec level)) 3) level)
		 (degree->second100 -90)))
	(re (min (* (+ (floor (/ esec   level)) 1) level)
		 (* (+ (floor (/ lonsec level)) 4) level)
		 (degree->second100 360)))
	(rw (max (* (- (floor (/ wsec   level)) 1) level)
		 (* (- (floor (/ lonsec level)) 3) level)
		 (degree->second100 0)))
	)
    `((n . ,rn) (e . ,re) (w . ,rw) (s . ,rs))
  ))

;; gennerate one overlay XML fragment
(define (gen-one-overlay lev wsec ssec)
  `(GroundOverlay
	(name ,(format #f "~0d:~0d:~0d" lev ssec wsec))
	(Icon (href
	       ,(format #f
			(if (direct-mode?)
			    "http://cyberjapan.jp/data/~0d/new/~0d/~0d-~0d-img.png"
			    "http://localhost/cgi-bin/cyber-earth-cache.cgi?filename=/data/~0d/new/~0d/~0d-~0d-img.png")
			(exact->inexact (/ lev 100)) wsec wsec ssec))
	      ;(refreshMode "onExpire")
	      )
	(LatLonBox
	 (north ,(second100->degree-i (+ ssec lev)))
	 (south ,(second100->degree-i ssec))
	 (east  ,(second100->degree-i (+ wsec lev)))
	 (west  ,(second100->degree-i wsec)))))


(define (main args)
  (cgi-main
   (lambda (param)
     (let ((bbox #f)
	   (w #f)
	   (s #f)
	   (e #f)
	   (n #f)
	   (lookatRange #f)
	   (lookatLon #f)
	   (lookatLat #f)
	   (lookatTilt #f)
	   (lev #f)
	   (sbbox #f)
	   (latlist #f)
	   (lonlist #f)
	   (gridlist #f)
	   )

       (set! bbox (map (lambda (v) (string->number v))
		       (string-split (cgi-get-parameter "BBOX" param) ",")))

       (set! w (list-ref bbox 0))
       (set! s (list-ref bbox 1))
       (set! e (list-ref bbox 2))
       (set! n (list-ref bbox 3))


       (set! lookatRange (string->number (cgi-get-parameter "lookatRange" param)))
       (set! lookatLon   (string->number (cgi-get-parameter "lookatLon"   param)))
       (set! lookatLat   (string->number (cgi-get-parameter "lookatLat"   param)))
       (set! lookatTilt  (string->number (cgi-get-parameter "lookatTilt"  param)))

       ;(set! lev (detect-maplevel (degree->second100 n)
	;			  (degree->second100 e)
	;			  (degree->second100 w)
	;			  (degree->second100 s)))
       (set! lev (detect-maplevel-r lookatRange lookatTilt))

       (set! sbbox (reshape-bbox lev
				 (degree->second100 n)
				 (degree->second100 e)
				 (degree->second100 w)
				 (degree->second100 s)
				 (degree->second100 lookatLat)
				 (degree->second100 lookatLon)))
       (set! latlist (make-pos-list
		      (assoc-ref sbbox 's)
		      lev
		      (assoc-ref sbbox 'n)))
       (set! lonlist (make-pos-list
		      (assoc-ref sbbox 'w)
		      lev
		      (assoc-ref sbbox 'e)))
       (set! gridlist (filter-map
		       (lambda (point)
			 (let ((ssec (list-ref point 0))
			       (wsec (list-ref point 1)))
			   (and (> wsec (- (assoc-ref *max-bbox* 'w) lev))
				(< wsec (assoc-ref *max-bbox* 'e))
				(> ssec (- (assoc-ref *max-bbox* 's) lev))
				(< ssec (assoc-ref *max-bbox* 'n))
				point)))
		       (append-map (lambda (lat)
				     (append-map (lambda (lon)
						   `((,lat ,lon)))
						 lonlist)) latlist)))

       (list
	(cgi-header :content-type "application/vnd.google-earth.kml+xml")
	(srl:sxml->xml
	 `(*TOP*
	   (*PI* xml "version=\"1.0\"")
	   (kml (@ (xmlns "http://earth.google.com/kml/2.0"))
		(Document
		 (Folder
		  (name "layers")
		  (open 0)
		  (description
		   ,#`"N:,n E:,e W:,w S:,s Lev:,lev Nbox:,(second100->degree-i (assoc-ref sbbox 'n)) Ebox:,(second100->degree-i (assoc-ref sbbox 'e)) Wbox:,(second100->degree-i (assoc-ref sbbox 'w)) Sbox:,(second100->degree-i (assoc-ref sbbox 's)) lr: ,lookatRange llat: ,lookatLat llon: ,lookatLon lt: ,lookatTilt"
		   ;; ,(format "~a" sbbox)
		   ;; ,(format "~a" gridlist)
		   )
		  ,@(map (lambda (pos)
			   (let ((ssec (list-ref pos 0))
				 (wsec (list-ref pos 1)))
			     (gen-one-overlay lev wsec ssec)))
			 gridlist)
		  )))))
	)))))

;;; end
