#!/usr/bin/gosh
;; -*- mode: scheme -*-
;;
;; Cyber Earth cache proxy
;;
;; By: YOKOTA Hiroshi

(use www.cgi)
(use rfc.http)
(use rfc.uri)
(use rfc.base64)
(use srfi-11)
(use srfi-13)
(use text.tree)

(use dbm)
(use dbm.fsdbm)
;(use dbm.gdbm)

;; proxy hostname and port number
;; set #f to disable proxy.
;;(define *proxy-host* "127.0.0.1")
;;(define *proxy-port* 8080)
(define *proxy-host* #f)
(define *proxy-port* #f)

(define *offline-file* "/tmp/cyber-earth-offline")

(define *db-path* "/tmp/cyber-earth.db")
(define *db-class* <fsdbm>)
;(define *db-class* <gdbm>)

;; dummy image data encoded by base64
(define *broken-image* (base64-decode-string "iVBORw0KGgoAAAANSUhEUgAAAAgAAAAIEAYAAACUn2LIAAAABmJLR0T///////8JWPfcAAAACXBIWXMAAABIAAAASABGyWs+AAAAOklEQVQoz2P8/5+BgYEBQpIDWNAFGBkRJDaAYSG6AC4X4VKH0wXoGnC5jIlcv1PNC0Q7FZdBjJRGIwCIUDfmr9EyzAAAAABJRU5ErkJggg=="))
(define *offline-image* (base64-decode-string "iVBORw0KGgoAAAANSUhEUgAAAAQAAAAEEAYAAAD5YUI9AAAABmJLR0T///////8JWPfcAAAACXBIWXMAAABIAAAASABGyWs+AAAAF0lEQVQI12NggIL//xEkCh+nBDog2wQAOLwf4aFzXgQAAAAASUVORK5CYII="))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (http-proxy-get proxyhost proxyport uri)
  (let ((hostname (values-ref (uri-parse uri) 2)))
    (http-get #`",|proxyhost|:,|proxyport|" uri :host hostname :user-agent "CyberEarth-cache/1.0")))

(define (http-get-uri uri)
  (if (and *proxy-host* *proxy-port*)
      (http-proxy-get *proxy-host* *proxy-port* uri)
      (http-get (values-ref (uri-parse uri) 2)
		(values-ref (uri-parse uri) 4))))

(define (offline?)
  (file-exists? *offline-file*))

(define (filename-valid? filename)
  (if (string? filename)
      (#/^\/data\/[0-9.]+\/new\/[0-9]+\/[0-9]+-[0-9]+-img\.png$/ filename)
      #f))

;; make dummy image data
(define (make-dummy img)
  (tree->string (append (cgi-header :status "200 replacement image" :content-type "image/png" "Content-Length" (string-size img))
			(list img))))


(define (png-image? img-str)
  ;; img-str may be an incomplete string.
  ;; so ordinary string compare function is not useable.
  (and (> (string-size img-str) 3)
       (= (string-byte-ref img-str 0) (char->integer #\x89))
       (= (string-byte-ref img-str 1) (char->integer #\P))
       (= (string-byte-ref img-str 2) (char->integer #\N))
       (= (string-byte-ref img-str 3) (char->integer #\G))))


;; DB utils
(define (ce-db-exists? key)
  (guard (e (else #f))
	 (let ((db (dbm-open *db-class*
			     :path *db-path*
			     :rw-mode :read))
	       (r #f))
	   (set! r (dbm-exists? db key))
	   (dbm-close db)
	   r)))

(define (ce-db-get key)
  (let ((db (dbm-open *db-class*
		      :path *db-path*
		      :rw-mode :read))
	(r #f))
    (set! r (dbm-get db key))
    (dbm-close db)
    r))

(define (ce-db-put! key val)
  (let ((db (dbm-open *db-class*
		      :path *db-path*
		      :rw-mode :write)))
    (dbm-put! db key val)
    (dbm-close db)))


(define (main args)
  (let* ((params   (cgi-parse-parameters))
	 (filename (cgi-get-parameter "filename" params)))
    (cond
     ((not (filename-valid? filename))
      (display (tree->string (cgi-header :status "403 filename invalid" :content-type "text/plain")))
      (display "filename invalid")
      (flush)
      (close-output-port (current-output-port))
      )

     ((ce-db-exists? filename)
      (let ((data (ce-db-get filename)))
	(display (tree->string (cgi-header :status "200 cached" :content-type "image/png"
					   "Content-Length" (string-size data))))
	(display data)
	(flush)
	(close-output-port (current-output-port))
	))

     ((offline?)
      (display (make-dummy *offline-image*))
      (flush)
      (close-output-port (current-output-port))
      )

     (else
      (let-values
       (((status head body)
	 (http-get-uri #`"http://cyberjapan.jp,|filename|")))
       (if (or (not (= (string->number status) 200))
	       (= (string-size body) 0)
	       (not (png-image? body))
	       )
	   (begin
	     (display (make-dummy *broken-image*))
	     (flush)
	     (close-output-port (current-output-port))
	     ;;(ce-db-put! filename *broken-image*) ; XXX: is this OK?
	     )
	   (begin
	     (display (tree->string (cgi-header :status "200 ok" :content-type "image/png" "Content-Length" (string-size body))))
	     (display body)
	     (flush)
	     (close-output-port (current-output-port))
	     (ce-db-put! filename body)
	     )
	   )))))
  0)

;;; end
